% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_rename}
\alias{umx_rename}
\title{umx_rename}
\usage{
umx_rename(x, replace = NULL, old = NULL, grep = NULL, test = FALSE)
}
\arguments{
\item{x}{the dataframe in which to rename variables}

\item{replace}{If used alone, a named collection of c(oldName = "newName") pairs
OR, if "old" is a list of existing names, the list of new names)
OR, if "grep" is a regular expression, the replace string)}

\item{old}{Optional list of old names that will be found and replaced by the contents of replace. Defaults to NULL}

\item{grep}{Optional grep string. Matches will be replaced using replace as the replace string. Defaults to NULL}

\item{test}{whether to report a "dry run" - and not actually change anything (defaults to false)}
}
\value{
- dataframe with columns renamed.
}
\description{
Returns a dataframe with variables renamed as desired.
Unlike some functions, it checks that the variables exist, and that the new names are not already used.
}
\details{
note: to use replace list, you must say c(old = "new"), not c(old -> "new")
}
\examples{
# Re-name "cyl" to "cylinder"
x = mtcars
x = umx_rename(x, replace = c(cyl = "cylinder"))
# alternate style
x = umx_rename(x, old = c("disp"), replace = c("displacement"))
umx_check_names("displacement", data = x, die = TRUE)
# This will warn that "disp" doesn't exist (anymore)
x = umx_rename(x, old = c("disp"), replace = c("displacement"))
x = umx_rename(x, grep = "lacement", replace = "") # use grep to set it back
umx_names(x, "^d")
}
\seealso{
Other Miscellaneous Functions: \code{\link{umxEval}};
  \code{\link{umxJiggle}}; \code{\link{umx_APA_pval}};
  \code{\link{umx_add_variances}}; \code{\link{umx_apply}};
  \code{\link{umx_check_model}};
  \code{\link{umx_check_multi_core}};
  \code{\link{umx_checkpoint}},
  \code{\link{umx_set_checkpoint}};
  \code{\link{umx_check}};
  \code{\link{umx_default_option}};
  \code{\link{umx_explode}};
  \code{\link{umx_get_CI_as_APA_string}};
  \code{\link{umx_get_bracket_addresses}};
  \code{\link{umx_get_checkpoint}};
  \code{\link{umx_get_cores}};
  \code{\link{umx_get_optimizer}};
  \code{\link{umx_has_CIs}};
  \code{\link{umx_has_been_run}};
  \code{\link{umx_has_means}};
  \code{\link{umx_has_square_brackets}};
  \code{\link{umx_is_MxMatrix}};
  \code{\link{umx_is_MxModel}}; \code{\link{umx_is_RAM}};
  \code{\link{umx_is_cov}};
  \code{\link{umx_is_endogenous}};
  \code{\link{umx_is_exogenous}};
  \code{\link{umx_is_ordered}}; \code{\link{umx_msg}};
  \code{\link{umx_names}}; \code{\link{umx_object_as_str}};
  \code{\link{umx_paste_names}}; \code{\link{umx_print}};
  \code{\link{umx_reorder}}; \code{\link{umx_rot}};
  \code{\link{umx_set_cores}};
  \code{\link{umx_set_optimizer}};
  \code{\link{umx_string_to_algebra}};
  \code{\link{umx_trim}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

