% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_rename}
\alias{umx_rename}
\title{umx_rename}
\usage{
umx_rename(x, replace = NULL, old = NULL, grep = NULL, test = FALSE)
}
\arguments{
\item{x}{the dataframe in which to rename variables}

\item{replace}{If used alone, a named collection of c(oldName = "newName") pairs
OR, if "old" is a list of existing names, the list of new names)
OR, if "grep" is a regular expression, the replace string)}

\item{old}{Optional list of old names that will be found and replaced by the contents of replace. Defaults to NULL}

\item{grep}{Optional grep string. Matches will be replaced using replace as the replace string. Defaults to NULL}

\item{test}{whether to report a "dry run" - and not actually change anything (defaults to false)}
}
\value{
- dataframe with columns renamed.
}
\description{
Returns a dataframe with variables renamed as desired.
Unlike some functions, it checks that the variables exist, and that the new names are not already used.
}
\details{
As a courtesy function, it handles grep replace in strings of characters.

note: to use replace list, you must say c(old = "new"), not c(old -> "new")
}
\examples{
# Re-name "cyl" to "cylinder"
x = mtcars
x = umx_rename(x, replace = c(cyl = "cylinder"))
# alternate style
x = umx_rename(x, old = c("disp"), replace = c("displacement"))
umx_check_names("displacement", data = x, die = TRUE)
# This will warn that "disp" doesn't exist (anymore)
x = umx_rename(x, old = c("disp"), replace = c("displacement"))
x = umx_rename(x, grep = "lacement", replace = "") # using grep to revert to disp
umx_names(x, "^d") # all names begining with a d
}
\seealso{
Other Utility Functions: \code{\link{qm}},
  \code{\link{umx_find_object}}, \code{\link{umx_grep}},
  \code{\link{umx_msg}}, \code{\link{umx_names}},
  \code{\link{umx_paste_names}}, \code{\link{umx_pb_note}},
  \code{\link{umx_print}}, \code{\link{umx}}
}

