% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_set_checkpoint}
\alias{umx_set_checkpoint}
\alias{umx_checkpoint}
\title{umx_set_checkpoint}
\usage{
umx_set_checkpoint(interval = 1, units = c("evaluations", "iterations",
  "minutes"), prefix = "", directory = getwd(), model = NULL)
}
\arguments{
\item{interval}{How many units between checkpoints: Default =  1.
A value of zero sets always to 'No' (i.e., do not checkpoint all models during optimization)}

\item{units}{units to count in: Default unit is 'evaluations' ('minutes' is also legal)}

\item{prefix}{string prefix to add to all checkpoint filenames (default = "")}

\item{directory}{a directory, i.e "~/Desktop" (defaults to getwd())}

\item{model}{(optional) model to set options in (default = NULL)}
}
\value{
- mxModel if provided
}
\description{
Set the checkpoint status for a model or global options
}
\examples{
umx_set_checkpoint(interval = 1, "evaluations", dir = "~/Desktop/")
# turn off checkpointing with interval = 0
umx_set_checkpoint(interval = 0)
umx_set_checkpoint(2, "evaluations", prefix="SNP_1")
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- umxRAM("One Factor", data = mxData(cov(demoOneFactor), type = "cov", numObs = 500),
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1.0)
)
m1 = umx_set_checkpoint(model = m1)
m1 = mxRun(m1)
umx_checkpoint(0)
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}, \url{http://openmx.ssri.psu.edu}
}
\seealso{
Other Get and set: \code{\link{umx_get_checkpoint}},
  \code{\link{umx_set_auto_plot}},
  \code{\link{umx_set_auto_run}},
  \code{\link{umx_set_condensed_slots}},
  \code{\link{umx_set_cores}},
  \code{\link{umx_set_optimizer}},
  \code{\link{umx_set_plot_format}},
  \code{\link{umx_set_table_format}}
}
