% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxACEcov}
\alias{umxACEcov}
\title{umxACEcov: Build and run a Cholesky with covariates in the covariance}
\usage{
umxACEcov(name = "ACEcov", selDVs, selCovs, dzData, mzData, suffix = NULL,
  dzAr = 0.5, dzCr = 1, addStd = TRUE, addCI = TRUE, boundDiag = NULL,
  equateMeans = TRUE, bVector = FALSE, thresholds = c("deviationBased",
  "left_censored"), autoRun = getOption("umx_auto_run"))
}
\arguments{
\item{name}{The name of the model (defaults to"ACE")}

\item{selDVs}{The variables to include from the data (do not include suffixes)}

\item{selCovs}{The covariates to include from the data (do not include suffixes)}

\item{dzData}{The DZ dataframe}

\item{mzData}{The MZ dataframe}

\item{suffix}{suffix for twin 1 and twin 2, often "_T" Used to expand selDVs into
full column names, i,e "dep" -->  c("dep_T1", "dep_T2")}

\item{dzAr}{The DZ genetic correlation (defaults to .5, vary to examine assortative mating)}

\item{dzCr}{The DZ "C" correlation (defaults to 1: set to .25 to make an ADE model)}

\item{addStd}{Whether to add the algebras to compute a std model (defaults to TRUE)}

\item{addCI}{Whether to add intervals to compute CIs (defaults to TRUE)}

\item{boundDiag}{= Whether to bound the diagonal of the a, c, and e matrices}

\item{equateMeans}{Whether to equate the means across twins (defaults to TRUE)}

\item{bVector}{Whether to compute row-wise likelihoods (defaults to FALSE)}

\item{thresholds}{How to implement ordinal thresholds: c("deviationBased", "left_censored")}

\item{autoRun}{Whether to run the model and return it, or just return it}
}
\value{
- \code{\link{mxModel}} of subclass mxModel.ACEcov
}
\description{
Make a 2-group ACE Cholesky Twin model with covariates modeled (see Details below)
}
\details{
umxACEcov supplements the \code{\link{umxACE}} Cholesky model with covariates.
}
\examples{
require(umx)
data(twinData)
# replicate age to age1 & age2
twinData$age1 = twinData$age2 = twinData$age
selDVs  = c("bmi") # Set the DV
selCovs = c("age") # Set the IV
selVars = umx_paste_names(selDVs, covNames = selCovs, sep = "", suffixes = 1:2)
# 80 rows so example runs fast
mzData = subset(twinData, zygosity == "MZFF", selVars)[1:80, ]
dzData = subset(twinData, zygosity == "DZFF", selVars)[1:80, ]
m1 = umxACEcov(selDVs = selDVs, selCovs = selCovs,
   dzData = dzData, mzData = mzData, suffix = "", autoRun = TRUE
)
umxSummary(m1)
plot(m1)
# ====================
# = A bivariate test =
# ====================
selDVs  = c("ht", "wt") # Set the DV
selCovs = c("age") # Set the IV
selVars = umx_paste_names(selDVs, covNames = selCovs, sep = "", suffixes = 1:2)
# 80 rows so example runs fast enough on CRAN
mzData = subset(twinData, zygosity == "MZFF", selVars)[1:80, ]
dzData = subset(twinData, zygosity == "DZFF", selVars)[1:80, ]
m1 = umxACEcov(selDVs = selDVs, selCovs = selCovs,
   dzData = dzData, mzData = mzData, suffix = "", autoRun = TRUE
)


# Univariate bmi without covariate of age for comparison
m2     = umxACE(selDVs = selDVs, dzData = dzData, mzData = mzData, suffix="")
x      = umx_residualize("bmi", "age", suffixes=1:2, twinData)
mzData = subset(x, zygosity == "MZFF", selVars)[1:80, ]
dzData = subset(x, zygosity == "DZFF", selVars)[1:80, ]
m3     = umxACE(selDVs = selDVs, dzData = dzData, mzData = mzData, suffix="")



}
\references{
- Neale, M. C., & Martin, N. G. (1989). The effects of age, sex, 
and genotype on self-report drunkenness following a challenge dose of alcohol. 
Behavior Genetics, 19, 63-78. doi:10.1007/BF01065884

Schwabe, I., Boomsma, D. I., Zeeuw, E. L., & Berg, S. M. (2015). A New Approach 
to Handle Missing Covariate Data in Twin Research : With an Application to
Educational Achievement Data. Behavior Genetics. doi:10.1007/s10519-015-9771-1
}
\seealso{
Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACESexLim}}, \code{\link{umxACE}},
  \code{\link{umxCF_SexLim}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxE}},
  \code{\link{umxIP}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx}}
}
