% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxACESexLim}
\alias{umxACESexLim}
\title{umxACESexLim: Build and run a sex-limitation twin model (not working yet)}
\usage{
umxACESexLim(name = "ACE_sexlim", selDVs, mzmData, dzmData, mzfData, dzfData,
  dzoData, suffix = NULL, autoRun = getOption("umx_auto_run"))
}
\arguments{
\item{name}{The name of the model (defaults to "ACE_sexlim")}

\item{selDVs}{The variables to include. If you provide a suffix, you can use just the base names.}

\item{mzmData}{The MZ male dataframe}

\item{dzmData}{The DZ male dataframe}

\item{mzfData}{The DZ female dataframe}

\item{dzfData}{The DZ female dataframe}

\item{dzoData}{The DZ opposite-sex dataframe. (be sure and get in right order)}

\item{suffix}{The suffix for twin 1 and twin 2, often "_T". If set, you can
omit suffixes in selDVs, i.e., just "dep" not c("dep_T1", "dep_T2")}

\item{autoRun}{Whether to mxRun the model (default TRUE: the estimated model will be returned)}
}
\value{
- ACE sexlim model
}
\description{
Cholesky style sex-limitation model.
}
\details{
This is a multi-variate capable Quantitative & Qualitative Sex-Limitation script using
ACE Cholesky modeling. It implements a correlation approach to ensure that order of variables
does NOT affect ability of model to account for DZOS data.
 
Restrictions include the assumption that twin means and variances can be equated across birth
order within zygosity groups.

Note: Qualitative sex differences are differences in the latent A, C, or E latent variables
Note: Quantitative sex differences are differences in the path loadings from A, C, or E 
to the measured variables
}
\examples{
\dontrun{
# Load Libraries
require(umx);
# =========================
# = Load and Process Data =
# =========================
data('us_skinfold_data')
# rescale variables
us_skinfold_data[,c('bic_T1', 'bic_T2')] <- us_skinfold_data[,c('bic_T1', 'bic_T2')]/3.4
us_skinfold_data[,c('tri_T1', 'tri_T2')] <- us_skinfold_data[,c('tri_T1', 'tri_T2')]/3
us_skinfold_data[,c('caf_T1', 'caf_T2')] <- us_skinfold_data[,c('caf_T1', 'caf_T2')]/3
us_skinfold_data[,c('ssc_T1', 'ssc_T2')] <- us_skinfold_data[,c('ssc_T1', 'ssc_T2')]/5
us_skinfold_data[,c('sil_T1', 'sil_T2')] <- us_skinfold_data[,c('sil_T1', 'sil_T2')]/5

# Select Variables for Analysis
varList = c('ssc','sil','caf','tri','bic')
selVars = umx_paste_names(varList, "_T", 1:2)

# Data objects for Multiple Groups
mzmData = subset(us_skinfold_data, zyg == 1, selVars)
dzmData = subset(us_skinfold_data, zyg == 3, selVars)
mzfData = subset(us_skinfold_data, zyg == 2, selVars)
dzfData = subset(us_skinfold_data, zyg == 4, selVars)
dzoData = subset(us_skinfold_data, zyg == 5, selVars)

m1 = umxACESexLim(selDVs = varList, suffix = "_T",
       mzmData = mzmData, dzmData = dzmData, 
       mzfData = mzfData, dzfData = dzfData, 
       dzoData = dzoData)
m1 = mxRun(m1)
# ===================================================
# = Test switching specific a from Males to females =
# ===================================================
m2 = umxSetParameters(m1, labels = "asm_.*", free = FALSE, values = 0, regex = TRUE)
m2 = umxSetParameters(m1, labels = "asf_.*", free = TRUE , values = 0, regex = TRUE)
m2 = mxRun(m2)
summary(m2)
umxCompare(m2, m1)
# does fit move on repeated execution?
# for (i in 1:4) { m2 <- mxRun(m2); print(m2 $output$mi) }
}
}
\references{
- Neale et al., (2006). Multivariate genetic analysis of sex-lim and GxE interaction, Twin Research & Human Genetics.,
\url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACE_cov_fixed}}, \code{\link{umxACEcov}},
  \code{\link{umxACEv}}, \code{\link{umxACE}},
  \code{\link{umxCF_SexLim}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxE}},
  \code{\link{umxIP}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}, \code{\link{umxReduceACE}},
  \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx_long2wide}}, \code{\link{umx_wide2long}},
  \code{\link{umx}}, \code{\link{xmu_twin_check}}
}
