% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavanify2ram.R
\name{umxLav2RAM}
\alias{umxLav2RAM}
\title{Convert a lavaan syntax string to a umxRAM model}
\usage{
umxLav2RAM(model = NA, data = "auto", name = NULL,
  lavaanMode = "sem", printTab = TRUE, group = NULL)
}
\arguments{
\item{model}{A lavaan syntax string, e.g. "A~~B"}

\item{data}{Data to add to model (defaults to auto, which is just sketch mode)}

\item{name}{Model name}

\item{lavaanMode}{Automagical path settings (default = "sem")}

\item{printTab}{= TRUE (more for debugging)}

\item{group}{= NULL TODO: define this}
}
\value{
\itemize{
\item list of \code{\link{umxPath}}s
}
}
\description{
Use lavaan syntax to create umxRAM models. If data are provided, a \code{umxRAM} model is returned.
If more than one group is found, a superModel is returned.

This function is at the alpha quality stage, and \strong{should be expected to have bugs}.
Several features are not yet supported. Let me know if you'd like them.
}
\details{
Uses the defaults of \code{lavaan::sem}
\itemize{
\item int.ov.free     = TRUE
\item int.lv.free     = FALSE
\item auto.fix.first  = TRUE (unless std.lv = TRUE)
\item auto.fix.single = TRUE
\item auto.var        = TRUE
\item auto.cov.lv.x   = TRUE
\item auto.th         = TRUE
\item auto.delta      = TRUE
\item auto.cov.y      = TRUE
\item fixed.x         = FALSE (not standard in lavaan::sem, but needed for RAM)
}

Lavaan is fabulously well documented. For quick reference, some common symbols in lavaan strings are

\tabular{rlll}{
\tab "=~"   \tab lhs (Latent) is manifested by rhs\cr
\tab "~"    \tab lhs "is regressed on" (<- ) rhs\cr
\tab "~~"   \tab lhs covarys with rhs\cr
\tab "~ 1"  \tab lhs has mean\cr
\tab ":="   \tab lhs is defined by rhs (see \code{\link[OpenMx:mxAlgebra]{OpenMx::mxAlgebra()}})\cr
\tab "=="   \tab lhs is constrained == to rhs (see \code{\link[OpenMx:mxConstraint]{OpenMx::mxConstraint()}} )
}
}
\examples{
# auto-data, print table, return umxRAM model
m1 = umxLav2RAM("y ~ x")

lav = "y ~ x1 + 2.4*x2 + x3"
tmp = umxLav2RAM(lav, data = "auto", printTab= FALSE)

# Add labels to parameters, e.g. "x3_loading" as a loading for x3->x1
tmp = umxLav2RAM("x1 ~ x3_loading*x3")

# Fix values, e.g. x2 -> y fixed at 2.4
tmp = umxLav2RAM("y ~ x1 + 2.4*x2; s =~ 0*y11 + 1*y12 + 2*y13 + 3*y14")

tmp = umxLav2RAM("L =~ X1 + X2; L ~ Y")

# Factor model showing auto-addition of correlations among exogenous latents
# and auto-residuals on manifests
data("HS.ability.data", package = "OpenMx")

cov(HS.ability.data[, c("visual"  , "cubes"   , "flags")])
cov(HS.ability.data[, c("paragrap", "sentence", "wordm")])
cov(HS.ability.data[, c("addition", "counting", "straight")])

HS = "spatial =~ visual   + cubes    + flags
      verbal  =~ paragrap + sentence + wordm
      speed   =~ addition + counting + straight"

m1 = umxRAM2(HS, data = umx_scale(HS.ability.data))

# more complex:

lav = " # Model 14 PROCESS Hayes - moderated mediation
gnt ~ a*cb
INT ~ b1*gnt + b2*cn + b3*cngn + c*cb

indirect := a*b1
direct := c

ab3 := a * b3
loCN := a * b1 + ab3 * -0.5
hiCN := a * b1 + ab3 * 0.5
"
tmp = umxRAM2(lav)
# plot showing ability to influence layout with max min same groupings
plot(tmp, max = c("cb", "cn", "cngn"), same = "gnt", min="INT")

# Algebra: e.g. b1^2
m1 = umxRAM2("x1~b1*x2; B1_sq := b1^2", data = demoOneFactor)

# Model with labeled parameters
lav = "
y ~ b1*x1 + b2*x2 + b3*x3
# constraints
b1 == (b2 + b3)^2
b1 > exp(b2 + b3)"

tmp = umxLav2RAM(lav)

}
\seealso{
\itemize{
\item \code{\link{umxRAM}}
}

Other Super-easy helpers: \code{\link{umxEFA}},
  \code{\link{umxRAM2}}, \code{\link{umxTwoStage}},
  \code{\link{umx}}
}
\concept{Super-easy helpers}
