% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_apply}
\alias{umx_apply}
\title{umx_apply}
\usage{
umx_apply(FUN, of, by = c("columns", "rows"), ...)
}
\arguments{
\item{FUN}{The function to apply.}

\item{of}{The dataframe to work with.}

\item{by}{Apply the function to columns or to rows (default = "columns")}

\item{...}{optional arguments to FUN, e.g., na.rm = TRUE.}
}
\value{
- object
}
\description{
Tries to make apply more readable. so "mean of x by columns", instead of "of x, by 2, mean"
Other functions to think of include:
\code{\link{cumsum}}, \code{\link{rowSums}}, \code{\link{colMeans}}, etc.
}
\examples{
umx_apply(mean, mtcars, by = "columns")
umx_apply(mean, of = mtcars, by = "columns")
umx_apply(mean, by = "rows", of = mtcars[1:3,], na.rm = TRUE)
}
\references{
- \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
- \code{\link{umx_aggregate}}

Other Miscellaneous Stats Helpers: \code{\link{reliability}},
  \code{\link{umxCov2cor}}, \code{\link{umxHetCor}},
  \code{\link{umx_cor}}, \code{\link{umx_fun_mean_sd}},
  \code{\link{umx_means}}, \code{\link{umx_r_test}},
  \code{\link{umx_round}}, \code{\link{umx_var}},
  \code{\link{umx}}
}
\concept{Miscellaneous Stats Helpers}
