% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_is_ordered}
\alias{umx_is_ordered}
\title{Test if one or more variables in a dataframe are ordered}
\usage{
umx_is_ordered(df, names = FALSE, strict = TRUE, binary.only = FALSE,
  ordinal.only = FALSE, continuous.only = FALSE)
}
\arguments{
\item{df}{A \code{\link{data.frame}} to look in for ordinal variables (if you offer a
matrix or vector, it will be upgraded to a dataframe)}

\item{names}{whether to return the names of ordinal variables, or a binary (T,F) list (default = FALSE)}

\item{strict}{whether to stop when unordered factors are found (default = TRUE)}

\item{binary.only}{only count binary factors (2-levels) (default = FALSE)}

\item{ordinal.only}{only count ordinal factors (3 or more levels) (default = FALSE)}

\item{continuous.only}{use with names = TRUE to get the names of the continuous variables}
}
\value{
- vector of variable names or Booleans
}
\description{
Return the names of any ordinal variables in a dataframe
}
\examples{
tmp = mtcars
tmp$cyl = ordered(mtcars$cyl) # ordered factor
tmp$vs = ordered(mtcars$vs) # binary factor
umx_is_ordered(tmp) # numeric indices
umx_is_ordered(tmp, names = TRUE)
umx_is_ordered(tmp, names = TRUE, binary.only = TRUE)
umx_is_ordered(tmp, names = TRUE, ordinal.only = TRUE)
umx_is_ordered(tmp, names = TRUE, continuous.only = TRUE)
umx_is_ordered(tmp, continuous.only = TRUE)
isContinuous = !umx_is_ordered(tmp)
tmp$gear = factor(mtcars$gear) # unordered factor
# nb: Factors are not necessarily ordered! By default unordered factors cause an message...
\dontrun{
tmp$cyl = factor(mtcars$cyl)
umx_is_ordered(tmp, names=TRUE)
}
}
\references{
- \url{https://www.github.com/tbates/umx}
}
\seealso{
Other Test: \code{\link{umx_check_OS}},
  \code{\link{umx_check_model}},
  \code{\link{umx_check_names}},
  \code{\link{umx_check_parallel}},
  \code{\link{umx_check}}, \code{\link{umx_has_CIs}},
  \code{\link{umx_has_been_run}},
  \code{\link{umx_has_means}},
  \code{\link{umx_has_square_brackets}},
  \code{\link{umx_is_MxData}},
  \code{\link{umx_is_MxMatrix}},
  \code{\link{umx_is_MxModel}}, \code{\link{umx_is_RAM}},
  \code{\link{umx_is_cov}},
  \code{\link{umx_is_endogenous}},
  \code{\link{umx_is_exogenous}}
}
\concept{Test}
