% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxSimplex.R
\name{umxPlotSimplex}
\alias{umxPlotSimplex}
\alias{plot.MxModelSimplex}
\title{Draw and display a graphical figure of a simplex model}
\usage{
umxPlotSimplex(x = NA, file = "name", digits = 2, means = FALSE,
  std = TRUE, format = c("current", "graphviz", "DiagrammeR"), ...)
}
\arguments{
\item{x}{The \code{\link{umxSimplex}} model to display graphically}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (defaults to 2)}

\item{means}{Whether to show means paths (defaults to FALSE)}

\item{std}{Whether to standardize the model (defaults to TRUE)}

\item{format}{= c("current", "graphviz", "DiagrammeR")}

\item{...}{Optional additional parameters}
}
\value{
- Optionally return the dot code
}
\description{
Options include digits (rounding), showing means or not, and which output format is desired.
}
\examples{
\dontrun{
# TODO Add code (from umxSimplex) to build simplex model help
data(iqdat)
mzData <- subset(iqdat, zygosity == "MZ")
dzData <- subset(iqdat, zygosity == "DZ")
nTimePoints = 4 # Number of time points
baseVarNames = paste0("IQ_age", 1:nTimePoints)
selDVs = tvars(baseVarNames, sep = "_T", suffixes= 1:2)
m1 = umxSimplex(selDVs = selDVs, sep = "_T", dzData = dzData, mzData = mzData)
plot(m1)
}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, simplex, ACEv, or ACE model.

- \code{\link{umxSimplex}}

Other Plotting functions: \code{\link{plot.MxModel}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACEv}},
  \code{\link{umxPlotACE}}, \code{\link{umxPlotCPnew}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxEbiv}},
  \code{\link{umxPlotGxE}}, \code{\link{umxPlotIP}},
  \code{\link{umx}}
}
