% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxReduceGxE}
\alias{umxReduceGxE}
\title{Reduce a GxE model.}
\usage{
umxReduceGxE(model, report = c("markdown", "inline", "html", "report"),
  baseFileName = "tmp_gxe", ...)
}
\arguments{
\item{model}{An \code{\link{mxModel}} to reduce.}

\item{report}{How to report the results. "html" = open in browser.}

\item{baseFileName}{(optional) custom filename for html output (defaults to "tmp").}

\item{...}{Other parameters to control model summary.}
}
\value{
best model
}
\description{
This function can perform model reduction for \link{umxGxE},
testing dropping means-moderation, a\code{,c} & e\code{, as well as c & c}, a & a` etc.

It reports the results in a table. Set the format of the table with
\link{umx_set_table_format}. Or set \code{report} to "html" to open a
table for pasting into a word processor.
}
\examples{
\dontrun{
model = umxReduce(model)
}
}
\references{
\itemize{
\item Wagenmakers, E.J., & Farrell, S. (2004). AIC model selection using Akaike weights.
\emph{Psychonomic Bulletin and Review}, \strong{11}, 192-196. \href{https://doi.org/10.3758/BF03206482}{doi:}.
}
}
\seealso{
\code{\link{umxReduceACE}}, \code{\link{umxReduce}}

Other Twin Reporting Functions: \code{\link{umxReduceACE}},
  \code{\link{umxReduce}}, \code{\link{umx}}
}
\concept{Twin Reporting Functions}
