% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{install.OpenMx}
\alias{install.OpenMx}
\alias{umx_update_OpenMx}
\title{Install OpenMx, with choice of builds}
\usage{
install.OpenMx(loc = c("NPSOL", "travis", "CRAN",
  "open travis build page", "UVa"), url = NULL, lib,
  repos = getOption("repos"))
}
\arguments{
\item{loc}{Version to get default is "NPSOL". "travis" (latest build),CRAN, list of builds.}

\item{url}{Custom URL. On Mac, set this to "Finder" and the package selected in the Finder will be installed.}

\item{lib}{Where to install the package.}

\item{repos}{Which repository to use (ignored currently).}
}
\value{
None
}
\description{
You can install OpenMx, including the latest NPSOL-enabled build of OpenMx. Options are:
\enumerate{
\item "NPSOL": Install from our repository (default): This is where we maintain binaries supporting parallel processing and NPSOL.
\item "travis": Install the latest travis built (MacOS only).
\item "CRAN": Install from CRAN.
\item "open travis build page": Open the list of travis builds in a browser window.
}
}
\examples{
\dontrun{
install.OpenMx() # gets the NPSOL version
install.OpenMx("NPSOL") # gets the NPSOL version explicitly
install.OpenMx("CRAN") # Get the latest CRAN version
install.OpenMx("open travis build page") # Open web page of travis builds
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\code{\link[=umxVersion]{umxVersion()}}

Other Miscellaneous Utility Functions: \code{\link{qm}()},
  \code{\link{umxBrownie}()}, \code{\link{umxFactor}()},
  \code{\link{umxLav2RAM}()}, \code{\link{umxVersion}()},
  \code{\link{umx_array_shift}()},
  \code{\link{umx_cont_2_quantiles}()},
  \code{\link{umx_find_object}()},
  \code{\link{umx_make}()}, \code{\link{umx_msg}()},
  \code{\link{umx_open_CRAN_page}()},
  \code{\link{umx_pad}()}, \code{\link{umx_pb_note}()},
  \code{\link{umx_print}()},
  \code{\link{umx_score_scale}()}, \code{\link{umx}},
  \code{\link{xmu_cell_is_on}()}
}
\concept{Miscellaneous Utility Functions}
