% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxPlotGxE}
\alias{umxPlotGxE}
\alias{plot.MxModelGxE}
\title{Plot the results of a GxE univariate test for moderation of ACE components.}
\usage{
umxPlotGxE(x, xlab = NA, location = "topleft",
  separateGraphs = FALSE, acergb = c("red", "green", "blue", "black"),
  ...)
}
\arguments{
\item{x}{A fitted \code{\link[=umxGxE]{umxGxE()}} model to plot}

\item{xlab}{String to use for the x label (default = NA, which will use the variable name)}

\item{location}{Where to plot the legend (default = "topleft")
see ?legend for alternatives like bottomright}

\item{separateGraphs}{(default = FALSE)}

\item{acergb}{Colors to use for plot c(a = "red", c = "green", e = "blue", tot = "black")}

\item{...}{Optional additional parameters}
}
\value{
None
}
\description{
Plot GxE results (univariate environmental moderation of ACE components).
Options include plotting the raw and standardized graphs separately, or in a combined panel.
You can also set the label for the x axis (xlab), and choose the location of the legend.
}
\examples{
require(umx)
data(twinData)
twinData$age1 = twinData$age2 = twinData$age
mzData = subset(twinData, zygosity == "MZFF")
dzData = subset(twinData, zygosity == "DZFF")
m1= umxGxE(selDVs= "bmi", selDefs= "age", dzData= dzData, mzData= mzData, sep="", tryHard="yes")
plot(m1)
umxPlotGxE(x = m1, xlab = "SES", separateGraphs = TRUE, location = "topleft")
}
\references{
\itemize{
\item \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}} work for IP, CP, GxE, SAT, and ACE models.
}

\itemize{
\item \code{\link[=umxGxE]{umxGxE()}}
}

Other Plotting functions: \code{\link{plot.MxLISRELModel}()},
  \code{\link{plot.MxModel}()},
  \code{\link{umxPlotACEcov}()},
  \code{\link{umxPlotACEv}()}, \code{\link{umxPlotACE}()},
  \code{\link{umxPlotCP}()}, \code{\link{umxPlotGxEbiv}()},
  \code{\link{umxPlotIP}()}, \code{\link{umxPlotSexLim}()},
  \code{\link{umxPlotSimplex}()}, \code{\link{umx}}
}
\concept{Plotting functions}
