% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu_make_top_twin_models.R
\name{xmuTwinUpgradeMeansToCovariateModel}
\alias{xmuTwinUpgradeMeansToCovariateModel}
\title{Not for end-users: Add a means model with covariates to a twin model}
\usage{
xmuTwinUpgradeMeansToCovariateModel(model, fullVars, fullCovs, sep)
}
\arguments{
\item{model}{The \code{\link[=umxSuperModel]{umxSuperModel()}} we are modifying (must have \code{MZ} \code{DZ} and \code{top} submodels)}

\item{fullVars}{the FULL names of manifest variables}

\item{fullCovs}{the FULL names of definition variables}

\item{sep}{How twin variable names have been expanded, e.g. "_T".}
}
\value{
\itemize{
\item model, now with means model extended to covariates.
}
}
\description{
Does the following to \code{model} (i.e., a umx top/MZ/DZ supermodel):
\enumerate{
\item Change \code{top.expMeans} to \code{top.intercept}.
\item Create \code{top.meansBetas} for beta weights in rows (of covariates) and columns for each variable.
\item Add matrices for each twin's data.cov vars (matrixes are called \code{T1DefVars}).
\item Switch \code{mxExpectationNormal} in each data group to point to the local \code{expMean}.
\item Add "expMean" algebra to each data group.
}
\itemize{
\item \code{grp.expMean} sums \code{top.intercept}  and grp.DefVars \%*\% top.meansBetas for each twin.
}
}
\details{
In umx models with no covariates, means live in \code{top$expMean}
}
\examples{
\dontrun{
data(twinData) # ?twinData from Australian twins.
twinData[, c("ht1", "ht2")] = twinData[, c("ht1", "ht2")] * 10
mzData = twinData[twinData$zygosity \%in\% "MZFF", ]
dzData = twinData[twinData$zygosity \%in\% "DZFF", ]
# m1 = umxACE(selDVs= "ht", sep= "", dzData= dzData, mzData= mzData, autoRun= FALSE)
# m2 = xmuTwinUpgradeMeansToCovariateModel(m1, fullVars = c("ht1", "ht2"),
# 	fullCovs = c("age1", "sex1", "age2", "sex2"), sep = "")
#
}

}
\seealso{
\itemize{
\item called by \code{\link[=xmuTwinSuper_Continuous]{xmuTwinSuper_Continuous()}}
}

Other xmu internal not for end user: 
\code{\link{umxModel}()},
\code{\link{umxRenameMatrix}()},
\code{\link{umxTwinMaker}()},
\code{\link{umx_APA_pval}()},
\code{\link{umx_fun_mean_sd}()},
\code{\link{umx_get_bracket_addresses}()},
\code{\link{umx_make}()},
\code{\link{umx_standardize}()},
\code{\link{umx_string_to_algebra}()},
\code{\link{umx}},
\code{\link{xmuHasSquareBrackets}()},
\code{\link{xmuLabel_MATRIX_Model}()},
\code{\link{xmuLabel_Matrix}()},
\code{\link{xmuLabel_RAM_Model}()},
\code{\link{xmuMI}()},
\code{\link{xmuMakeDeviationThresholdsMatrices}()},
\code{\link{xmuMakeOneHeadedPathsFromPathList}()},
\code{\link{xmuMakeTwoHeadedPathsFromPathList}()},
\code{\link{xmuMaxLevels}()},
\code{\link{xmuMinLevels}()},
\code{\link{xmuPropagateLabels}()},
\code{\link{xmuRAM2Ordinal}()},
\code{\link{xmuTwinSuper_Continuous}()},
\code{\link{xmu_CI_merge}()},
\code{\link{xmu_CI_stash}()},
\code{\link{xmu_DF_to_mxData_TypeCov}()},
\code{\link{xmu_PadAndPruneForDefVars}()},
\code{\link{xmu_cell_is_on}()},
\code{\link{xmu_check_levels_identical}()},
\code{\link{xmu_check_needs_means}()},
\code{\link{xmu_check_variance}()},
\code{\link{xmu_clean_label}()},
\code{\link{xmu_data_missing}()},
\code{\link{xmu_data_swap_a_block}()},
\code{\link{xmu_describe_data_WLS}()},
\code{\link{xmu_dot_make_paths}()},
\code{\link{xmu_dot_make_residuals}()},
\code{\link{xmu_dot_maker}()},
\code{\link{xmu_dot_move_ranks}()},
\code{\link{xmu_dot_rank_str}()},
\code{\link{xmu_extract_column}()},
\code{\link{xmu_get_CI}()},
\code{\link{xmu_lavaan_process_group}()},
\code{\link{xmu_make_TwinSuperModel}()},
\code{\link{xmu_make_bin_cont_pair_data}()},
\code{\link{xmu_make_mxData}()},
\code{\link{xmu_match.arg}()},
\code{\link{xmu_name_from_lavaan_str}()},
\code{\link{xmu_path2twin}()},
\code{\link{xmu_path_regex}()},
\code{\link{xmu_safe_run_summary}()},
\code{\link{xmu_set_sep_from_suffix}()},
\code{\link{xmu_show_fit_or_comparison}()},
\code{\link{xmu_simplex_corner}()},
\code{\link{xmu_standardize_ACEcov}()},
\code{\link{xmu_standardize_ACEv}()},
\code{\link{xmu_standardize_ACE}()},
\code{\link{xmu_standardize_CP}()},
\code{\link{xmu_standardize_IP}()},
\code{\link{xmu_standardize_RAM}()},
\code{\link{xmu_standardize_SexLim}()},
\code{\link{xmu_standardize_Simplex}()},
\code{\link{xmu_start_value_list}()},
\code{\link{xmu_starts}()},
\code{\link{xmu_twin_add_WeightMatrices}()},
\code{\link{xmu_twin_check}()},
\code{\link{xmu_twin_get_var_names}()},
\code{\link{xmu_twin_upgrade_selDvs2SelVars}()}
}
\concept{xmu internal not for end user}
