% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu.R
\name{xmu_dot_mat2dot}
\alias{xmu_dot_mat2dot}
\title{Return dot code for paths in a matrix}
\usage{
xmu_dot_mat2dot(
  x,
  cells = c("diag", "lower", "lower_inc", "upper", "upper_inc", "any", "left"),
  from = c("rows", "cols"),
  fromLabel = NULL,
  toLabel = NULL,
  showFixed = FALSE,
  arrows = c("forward", "both", "back"),
  fromType = NULL,
  toType = NULL,
  digits = 2,
  model = NULL,
  SEstyle = FALSE,
  p = list(str = "", latents = c(), manifests = c())
)
}
\arguments{
\item{x}{a \code{\link[=umxMatrix]{umxMatrix()}} to make paths from.}

\item{cells}{which cells to process: "any" (default), "diag", "lower", "upper". "left" is the left half (e.g. in a twin means matrix)}

\item{from}{one of "rows", "columns"}

\item{fromLabel}{= NULL. NULL = use matrix name (default). If one, if suffixed with index, length() > 1, index into list. "one" is special.}

\item{toLabel}{= NULL. NULL = use matrix name (default). If one, if suffixed with index, length() > 1, index into list.}

\item{showFixed}{= FALSE.}

\item{arrows}{"forward" "both" or "back"}

\item{fromType}{one of "latent" or "manifest" NULL (default) = don't accumulate new names.}

\item{toType}{one of "latent" or "manifest" NULL (default) = don't accumulate new names.}

\item{digits}{to round values to (default = 2).}

\item{model}{If you want to get CIs, you can pass in the model (default = NULL).}

\item{SEstyle}{If TRUE, CIs shown as "b(SE)" ("b [l,h]" if FALSE (default)). Ignored if model NULL.}

\item{p}{input to build on. list(str = "", latents = c(), manifests = c())}
}
\value{
\itemize{
\item list(str = "", latents = c(), manifests = c())
}
}
\description{
Return dot code for paths in a matrix is a function which walks the rows and cols of a matrix.
At each free cell, it creates a dot-string specifying the relevant path, e.g.:

\code{ai1 -> var1 [label=".35"]}

Its main use is to correctly generate paths (and their sources and sink objects)
without depending on the label of the parameter.

It is highly customizable:
\enumerate{
\item You can specify which cells to inspect, e.g. "lower".
\item You can choose how to interpret path direction, from = "cols".
\item You can choose the label for the from to ends of the path (by default, the matrix name is used).
\item Offer up a list of from and toLabel which will be indexed into for source and sink
\item You can set the number of arrows on a path (e.g. both).
\item If \code{type} is set, then sources and sinks added manifests and/or latents output (p)
}

Finally, you can pass in previous output and new paths will be concatenated to these.
}
\examples{

# test with a 1 * 1
a_cp = umxMatrix("a_cp", "Lower", 1, 1, free = TRUE, values = pi)
out = xmu_dot_mat2dot(a_cp, cells = "lower_inc", from = "cols", arrows = "both")
cat(out$str) # a_cp -> a_cp [dir = both label="2"];
out = xmu_dot_mat2dot(a_cp, cells = "lower_inc", from = "cols", arrows = "forward",
	fromLabel = "fromMe", toLabel = "toYou", 
	fromType  = "latent", toType  = "manifest", digits = 3, SEstyle = TRUE
	)
cat(out$str) # fromMe -> toYou [dir = forward label="3.142"];
cat(out$latent) # fromMe
cat(out$manifest) # toYou

# Make a lower 3 * 3 value= 1:6 (1, 4, 6 on the diag)
a_cp = umxMatrix("a_cp", "Lower", 3, 3, free = TRUE, values = 1:6)

# Get dot strings for lower triangle (default from and to based on row and column number)
out = xmu_dot_mat2dot(a_cp, cells = "lower", from = "cols", arrows = "both")
cat(out$str) # a_cp1 -> a_cp2 [dir = both label="2"];

# one arrow (the default = "forward")
out = xmu_dot_mat2dot(a_cp, cells = "lower", from = "cols")
cat(out$str) # a_cp1 -> a_cp2 [dir = forward label="2"];

# label to (rows) using var names

out = xmu_dot_mat2dot(a_cp, toLabel= paste0("v", 1:3), cells = "lower", from = "cols")
umx_msg(out$str) # a_cp1 -> v2 [dir = forward label="2"] ...

# First call also inits the plot struct
out = xmu_dot_mat2dot(a_cp, from = "rows", cells = "lower", arrows = "both", fromType = "latent")
out = xmu_dot_mat2dot(a_cp, from = "rows", cells = "diag", 
		toLabel= "common", toType = "manifest", p = out)
umx_msg(out$str); umx_msg(out$manifests); umx_msg(out$latents)

# ================================
# = Add found sinks to manifests =
# ================================
out = xmu_dot_mat2dot(a_cp, from= "rows", cells= "diag", 
		toLabel= c('a','b','c'), toType= "manifest");
umx_msg(out$manifests)

# ================================
# = Add found sources to latents =
# ================================
out = xmu_dot_mat2dot(a_cp, from= "rows", cells= "diag", 
		toLabel= c('a','b','c'), fromType= "latent");
umx_msg(out$latents)


# ========================
# = Label a means matrix =
# ========================

tmp = umxMatrix("expMean", "Full", 1, 4, free = TRUE, values = 1:4)
out = xmu_dot_mat2dot(tmp, cells = "left", from = "rows",
	fromLabel= "one", toLabel= c("v1", "v2")
)
cat(out$str)

\dontrun{
# ==============================================
# = Get a string which includes CI information =
# ==============================================
data(demoOneFactor)
latents = c("g"); manifests = names(demoOneFactor)
m1 = umxRAM("xmu_dot", data = demoOneFactor, type = "cov",
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1.0)
)
m1 = umxCI(m1, run= "yes")
out = xmu_dot_mat2dot(m1$A, from = "cols", cells = "any", 
      toLabel= paste0("x", 1:5), fromType = "latent", model= m1);
umx_msg(out$str); umx_msg(out$latents)

}

}
\seealso{
\itemize{
\item \code{\link[=plot]{plot()}}
}

Other Graphviz: 
\code{\link{xmu_dot_define_shapes}()},
\code{\link{xmu_dot_make_paths}()},
\code{\link{xmu_dot_make_residuals}()},
\code{\link{xmu_dot_maker}()},
\code{\link{xmu_dot_rank}()}
}
\concept{Graphviz}
