% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneAnno.R
\docType{methods}
\name{getNihQuery}
\alias{getNihQuery}
\alias{getNihQuery,query-method}
\title{create initial NIH Query}
\usage{
getNihQuery(x, db, query)

\S4method{getNihQuery}{query}(x, db, query)
}
\arguments{
\item{x}{\code{query} object.}

\item{db}{The name of the NCBI database to be searched for the query, e.g. "gene" or "pubmed"}

\item{query}{The query string for the database}
}
\value{
\code{query} object a copy of the input object 'x', having the query specifiers from NIH added.
}
\description{
\code{getNihQuery} contacts the NIH E-utilities and carries out an initial data query.
Accessing the NCBI NIH databases is a two stage process; the \code{getNihQuery} function
carries out the first stage, returning a short list of IDs and a unique query key. This Query key
is then used in the second stage to fetch the results of the query.
}
\section{Methods (by class)}{
\itemize{
\item \code{query}: \code{query} object a copy of the input object 'x', having the query specifiers from NIH added.
}}
\examples{
\dontrun{
f <- query()
f@gene <- "BRAF"
db <- "gene"
f <- getNihQuery(f,db,f@gene)
gene <- getNihSummary(gene(),f)
}
}
\seealso{
\url{http://www.ncbi.nlm.nih.gov/books/NBK25500/}
}

