% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pclm_fit.R
\name{build_C_matrix}
\alias{build_C_matrix}
\title{Build Composition Matrices}
\usage{
build_C_matrix(x, y, nlast, offset, out.step, type)
}
\arguments{
\item{x}{Vector containing the starting values of the input intervals/bins.
For example: if we have 3 bins \code{[0,5), [5,10) and [10, 15)},
\code{x} will be defined by the vector: \code{c(0, 5, 10)}.}

\item{y}{Vector with counts to be ungrouped. It must have the same dimension as \code{x}.}

\item{nlast}{Length of the last interval. In the example above \code{nlast} would be 5.}

\item{offset}{Optional offset term to calculate smooth mortality rates. 
A vector of the same length as x and y. See \insertCite{rizzi2015;textual}{ungroup} 
for further details.}

\item{out.step}{Length of estimated intervals in output. 
Values between 0.1 and 1 are accepted. Default: 1.}

\item{type}{Type of PCLM model. Options: \code{"1D", "2D"} for 
univariate and two-dimensional model respectively.}
}
\description{
Build Composition Matrices
}
\keyword{internal}
