% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cornell.R
\docType{data}
\name{cornell_3_accent}
\alias{cornell_3_accent}
\title{Accent colors of Cornell University, USA}
\format{
An object of class \code{character} of length 9.
}
\source{
Color definitions are based on the
\href{https://brand.cornell.edu/design-center/colors/}{Color manual}.
}
\usage{
cornell_3_accent
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{cornell_3_accent} provides the nine primary colors
of the \href{https://www.cornell.edu/}{Cornell University}, USA.
}
\details{
Although our primary and secondary palettes should guide most layouts, in certain instances other colors may be needed.
For those circumstances, refer to the accent palette.
These colors should not be used as full-color bleeds and should be used periodically and in moderation.

This secondary colors are 
\code{"cornell_blue"} (defined as HEX #006699),
\code{"cornell_green_graphic"} (defined as HEX #6EB43F),
\code{"cornell_green_text"} (defined as HEX #4B7B2B),
\code{"cornell_green_text_big"} (defined as HEX #578E32),
\code{"cornell_orange_graphic"} (defined as HEX #F8981D),
\code{"cornell_orange_text"} (defined as HEX #D47500),
\code{"cornell_red_graphic"} (defined as HEX #EF4035),
\code{"cornell_red_text"} (defined as HEX #DF1E12), and
\code{"cornell_navy"} (defined as HEX #073949).
}
\examples{
cornell_3_accent
unikn::seecol(cornell_3_accent, main = "Accent colors Cornell Uni") # view color palette

}
\seealso{
\code{\link{cornell_1}} for primary colors of Cornell University;
\code{\link{cornell_2}} for primary colors of Cornell University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCLA_4}},
\code{\link{UCSD_1}},
\code{\link{UCSD_2}},
\code{\link{UCSD_3}},
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{columbia}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
