% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Mannheim.R
\docType{data}
\name{uni_mannheim_1}
\alias{uni_mannheim_1}
\title{Main color gradient of the University of Mannheim, Germany}
\format{
An object of class \code{character} of length 7.
}
\source{
Color definitions are based on 
\url{https://www.uni-mannheim.de/cd/marke/farben/}.
}
\usage{
uni_mannheim_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_mannheim_1} provides a color gradient of 
the primary \code{blau} color and six lighter shades 
of the \href{https://www.uni-mannheim.de}{University of Mannheim}, Germany.
}
\details{
The primary color \code{UM blau} is alternatively defined as 
\code{RGB 0/48/86}, \code{HEX #003056}, \code{Pantone 654}, \code{CMYK 100/60/10/60}, or \code{RAL 5011}. 

The six lighter shades were created by mixing the primary \code{UM blau} with \code{"white"}.  
See the \code{\link{ac}} and \code{\link{usecol}} functions for creating color gradients.
}
\examples{
uni_mannheim_1
unikn::seecol(uni_mannheim_1, main = "Main color gradient of the University of Mannheim")
unikn::demopal(uni_mannheim_1, type = 1, 
               main = "Main color gradient of Mannheim University")

}
\seealso{
\code{\link{uni_mannheim_2}} provides the primary and accent colors of the University of Mannheim;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0}},
\code{\link{fu_1}},
\code{\link{fu_2}},
\code{\link{fu_3}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_1}},
\code{\link{hu_2_2022}},
\code{\link{hu_2}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2022-12-30.
}
\concept{German university color palettes}
\keyword{datasets}
