% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Koeln.R
\docType{data}
\name{uni_koeln_1}
\alias{uni_koeln_1}
\title{Primary colors of the University of Koeln (Cologne), Germany}
\format{
An object of class \code{character} of length 7.
}
\source{
Color definitions are based on 
\url{https://kommunikation-marketing.uni-koeln.de/marketing/corporate_design/index_ger.html}.
}
\usage{
uni_koeln_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_koeln_1} provides the primary colors 
of the \href{https://www.uni-koeln.de}{Universitaet zu Koeln}, Germany.
}
\details{
The first 6 colors are variants of the main color \code{blaugrau} 
(defined as R122.G147.B171, see \code{uni_koeln_1[4]}). 

The 7th color is the accent color \code{signal rot} 
(defined as Pantone Red 032 C or R175.G17.B29, see \code{uni_koeln_1[7]}). 
The accent color may also be used in lighter shades of 80%, 60%, or 40%.
}
\examples{
uni_koeln_1
unikn::seecol(uni_koeln_1, main = "Primary colors of Uni Koeln")
unikn::demopal(uni_koeln_1, type = 4, 
               main = "Primary colors at the University of Cologne")

}
\seealso{
\code{\link{uni_koeln_2}} for departmental colors of the University of Koeln;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0}},
\code{\link{fu_1}},
\code{\link{fu_2}},
\code{\link{fu_3}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2022-12-05.
}
\concept{German university color palettes}
\keyword{datasets}
