% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_functions.R
\name{uniset_copyFilesToPackage}
\alias{uniset_copyFilesToPackage}
\title{Copy Uniset Files into Target Package}
\usage{
uniset_copyFilesToPackage(
  pathToPackage,
  setupFunc = NULL,
  taPaSH = "def",
  taPaObj = "settings",
  tmpl = "_TEMPLATE"
)
}
\arguments{
\item{pathToPackage}{Character length one. The path to the root of the
target package.}

\item{setupFunc}{Character length one. The name of the function 
\strong{in the target package} that is containing the setup-function 
\code{\link{uniset_setup}}.}

\item{taPaSH}{Character length one. The name of the variable to be defined in
the '.Renviron' file, leading to the place where the settings.R file for the
target package will be stored. If left at the default 'def', \code{'taPaName_SH'}
will be used, with 'taPaName' being the value provided at the argument
'taPaName'.}

\item{taPaObj}{Character length one. The name of the object holding the list
with the key-value pairs that can be defined to be used in the target package. 
Can be left at the default 'settings'.}

\item{tmpl}{Character length one. the Character string that will be appended
to the fresh settings file that is copied (by the target package) to the users 
settings home directory if updating the key=value pairs was not successful. 
Can be left at the default '_TEMPLATE'.}
}
\value{
Writes the four required files directly into a valid R-package folder
structure. Returns (invisible) NULL.
}
\description{
Generate the four files required in the target
package (i.e. the package that should be enabled to use the package 'uniset').
The generated files will be copied directly into their required destination
folders in the target package. The name of the target package will be extracted
from the description file.
}
\section{Note}{
 Please refer to \code{\link{uniset}} for a link to examples 
and a real-world demo.
}

\examples{
{
library(uniset)
# first copy the target package example into tempdir
to <- tempdir()
from <- paste0(path.package("uniset"), "/examples/dogPack")
file.copy(from, to, recursive = TRUE) 
# now copy the four required files directly into the package 'dogPack'
path <- paste0(to, "/dogPack")
uniset_copyFilesToPackage(path, "nameOfSetupFunc")
}
}
\seealso{
\code{\link{uniset_getFiles}}
}
