% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\name{unitizer_sect}
\alias{unitizer_sect}
\title{Define a \code{unitizer} Section}
\usage{
unitizer_sect(
  title = NULL,
  expr = expression(),
  details = character(),
  compare = new("testFuns")
)
}
\arguments{
\item{title}{character 1 length title for the section, can be omitted
though if you do omit it you will have to refer to the subsequent
arguments by name (i.e. \code{unitizer_sect(expr=...)})}

\item{expr}{test expression(s), most commonly a call to \code{{}} with
several calls inside (see examples)}

\item{details}{character more detailed description of what the purpose
of the section is; currently this doesn't do anything.}

\item{compare}{a function or a \code{\link{testFuns}} object}
}
\description{
The purpose of \code{unitizer} sections is to allow the user to tag a
group of test expressions with meta information as well as to modify
how tests are determined to pass or fail.
}
\note{
if you want to modify the functions used to compare conditions,
keep in mind that the conditions are stored in \code{\link{conditionList}}
objects so your function must loop through the lists and compare conditions
pairwise.  By default \code{unitizer} uses the \code{all.equal} method for S4
class \code{conditionList}.

\code{untizer} does not account for sections when matching new and
reference tests.  All tests will be displayed as per the section they belong
to in the newest version of the test file, irrespective of what section they
were in when the tests were last run.

Calls to \code{unitizer_sect} should be at the top level of your test
script, or nested within other \code{unitizer_sect}s (see "Nested Sections").
Do not expect code like \code{(untizer_sect(..., ...))} or
\code{{unitizer_sect(..., ...)}} or \code{fun(unitizer_sect(..., ...))} to
work.
}
\section{Tested Data}{


\code{unitizer} tracks the following:
\itemize{
  \item value: the return value of the test
  \item conditions: any conditions emitted by the test (e.g. warnings or
    errors)
  \item output: screen output
  \item message: stderr output
  \item aborted: whether the test issued an `abort` restart (e.g. by calling
    `stop` directly or indirectly)
}
In the future stdout produced by the test expression itself may be captured
separately from that produced by print/showing of the return value, but at
this point the two are combined.

Each of the components of the test data can be tested, although by default
only \code{value} and \code{condition} are checked.  Testing \code{output} is
potentially duplicative of testing \code{value}, since most often
\code{value} is printed to screen and the screen output of the value closely
correlates to the actual value.  In some cases it is useful to explicitly
test the \code{output}, such as when testing \code{print} or \code{show}
methods.
}

\section{Comparison Functions}{


The comparison function should accept at least two parameters, and
require no more than two.  For each test component, the comparison function
will be passed the reference data as the first argument, and the newly
evaluated data as the second.  The function should return TRUE if the
compared test components are considered equivalent, or FALSE.  Instead of
FALSE, the function may also return a character vector describing the
mismatch, as \code{\link{all.equal}} does.

\bold{WARNING}: Comparison functions that set and/or unset \code{\link{sink}}
can potentially cause problems.  If for whatever reason you must really  sink
and unsink output streams, please take extreme care to restore the streams to
the state they were in when the comparison function was called.

Any output to \code{stdout} or \code{stderr} is captured and only checked at
the end of the \code{unitizer} process with the expectation that there will
be no such output.

\code{value} and \code{conditions} are compared with \code{\link{all_eq}},
which is a wrapper to \code{\link{all.equal}} except that it returns FALSE
instead of a descriptive string on failure.  This is because \code{unitizer}
will run \code{\link[diffobj]{diffObj}} on the test data components that do
not match and including the \code{all.equal} output would be redundant.

If a comparison function signals a condition (e.g. throws a warning) the
test will not be evaluated, so make sure that your function does not signal
conditions unless it is genuinely failing.

If you wish to provide custom comparison functions you may do so by passing
an appropriately initialized \code{\link{testFuns}} object as the
value to the \code{compare} parameter to \code{unitizer_sect}
(see examples).

Make sure your comparison functions are available to \code{\link{unitize}}.
Comparisons will be evaluated in the environment of the test.  By default
\code{\link{unitize}} runs tests in environments that are not children to
the global environment, so functions defined there will not be automatically
available.  You can either specify the function in the test file before the
section that uses it, or change the base environment tests are evaluated in
with \code{unitize(..., par.env)}, or make sure that the package that
contains your function is loaded within the test script.
}

\section{Nested Sections}{


It is possible to have nested sections, but titles, etc. are ignored.  The
only effect of nested sections is to allow you to change the comparison
functions for a portion of the outermost \code{unitizer_sect}.
}

\examples{
unitizer_sect("Switch to `all.equal` instead of `all_eq`",
  {
    fun(6L)
    fun("hello")
  },
  compare=testFuns(value=all.equal, conditions=all.equal)
)
unitizer_sect("Use identical for ALL test data, including stdout, etc.",
  {
    fun(6L)
    fun("hello")
  },
  compare=identical
)
}
\seealso{
\code{\link{testFuns}}, \code{\link{all_eq}}
}
