% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid_udunits.R
\name{valid_udunits}
\alias{valid_udunits}
\alias{valid_udunits_prefixes}
\title{Get information about valid units}
\usage{
valid_udunits(quiet = FALSE)

valid_udunits_prefixes(quiet = FALSE)
}
\arguments{
\item{quiet}{logical, defaults \code{TRUE} to give a message about the location of
the udunits database being read.}
}
\value{
a data frame with columns \code{symbol} , \code{symbol_aliases} ,
  \code{name_singular} , \code{name_singular_aliases} , \code{name_plural} ,
  or \code{name_plural_aliases} , \code{def} , \code{definition} ,
  \code{comment} , \code{dimensionless} and \code{source_xml}
}
\description{
The returned dataframe is constructed at runtime by reading the xml database
that powers unit conversion in [package:udunits2]. Inspect this dataframe to
determine what inputs are accepted by \code{as_units} (and the other
functions it powers: \code{as_units} , \code{set_units} , \code{units<-}).
}
\details{
Any entry listed under \code{symbol} , \code{symbol_aliases} , \code{
name_singular} , \code{name_singular_aliases} , \code{name_plural} , or
\code{name_plural_aliases} is valid. Additionally, any entry under
\code{symbol} or \code{symbol_aliases} may can also contain a valid prefix,
as specified by \code{valid_udunits_prefixes()} .

Note, this is primarily intended for interactive use, the exact format of the
returned dataframe may change in the future.
}
\examples{
if (requireNamespace("xml2", quietly = TRUE)) {
  valid_udunits()
  valid_udunits_prefixes()
  if(interactive())
    View(valid_udunits())
}
}
