% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_units.R
\name{scale_units}
\alias{scale_x_units}
\alias{scale_y_units}
\title{Position scales for units data}
\usage{
scale_x_units(..., position = "bottom", unit = NULL)

scale_y_units(..., unit = NULL)
}
\arguments{
\item{...}{arguments passed on to \code{\link[ggplot2]{continuous_scale}}.}

\item{position}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}

\item{unit}{A unit specification to use for the axis. If given, the values
will be converted to this unit before plotting. An error will be thrown if
the specified unit is incompatible with the unit of the data.}
}
\description{
These are the default scales for the \code{units} class. These will usually
be added automatically. To override manually, use \code{scale_*_units}.
}
\examples{
if (requireNamespace("ggplot2", quietly=TRUE)) {

library(ggplot2)

mtcars$consumption <- set_units(mtcars$mpg, mi / gallon)
mtcars$power <- set_units(mtcars$hp, hp)

# Use units encoded into the data
ggplot(mtcars) +
  geom_point(aes(power, consumption))

# Convert units on the fly during plotting
ggplot(mtcars) +
  geom_point(aes(power, consumption)) +
  scale_x_units(unit = "W") +
  scale_y_units(unit = "km/l")

# Resolve units when transforming data
ggplot(mtcars) +
  geom_point(aes(power, 1 / consumption))

}
}
