% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dims.R
\name{dims}
\alias{dims}
\alias{dims.default}
\alias{dims.factor}
\title{Dimensions}
\usage{
dims(x, ...)

\method{dims}{default}(x, ...)

\method{dims}{factor}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
An integer vector of the dimensions.
}
\description{
Gets the dimensions of an object.
}
\details{
Unlike \code{base::dim()}, dims returns the length of an atomic vector.
}
\examples{
dims(numeric(0))
dims(1:3)
dims(factor("a"))
dims(matrix(1:4, nrow = 2L))
dims(array(1:9, dim = c(3L,1L,3L)))
dims(ToothGrowth)
dims(Titanic)
}
\seealso{
\code{\link[base:dim]{base::dim()}}

Other dimensions: 
\code{\link{ndims}()},
\code{\link{npdims}()},
\code{\link{pdims}()}
}
\concept{dimensions}
