% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unm_summary.R
\name{unm_summary}
\alias{unm_summary}
\alias{unm_backfill}
\alias{unm_dic}
\title{Generate synthetic data}
\usage{
unm_summary(mod, data, quantiles = c(0.025, 0.975))

unm_backfill(data, mod)

unm_dic(mod)
}
\arguments{
\item{mod}{Output from \code{\link[=unm_glm]{unm_glm()}}.}

\item{data}{The data \code{mod} was generated with.}

\item{quantiles}{A numeric vector of quantiles.}
}
\value{
A \code{tibble}
}
\description{
\code{\link[=unm_summary]{unm_summary()}} produces result summaries of the results from the model fitting
function, \code{\link[=unm_glm]{unm_glm()}}. The table of results are summarized from the MCMC draws of
the posterior distribution.
}
\examples{

\donttest{

# ~~ One Unmeasured Confounder Examples (II-Stage Model) ~~

# normal response, normal confounder model with internally validated data
(df <- runm(20, response = "norm"))

(unm_mod <- unm_glm(
  y ~ x + z1 + z2 + z3 + u1, family1 = gaussian(),
  u1 ~ x + z1 + z2 + z3,     family2 = gaussian(),
  data = df
))

glm(y ~ x + z1 + z2 + z3, data = df)

coef(unm_mod)
jags_code(unm_mod)
unm_summary(unm_mod)
unm_summary(unm_mod, df) # true values known df

# impute missing values with model
unm_backfill(df, unm_mod)

}

}
