#' Language Information
#'
#' A dataset containing the names, date orders, stop words,
#' simplifications, and replacements of 4 languages.
#'
#' @docType data
#' @keywords datasets
#' @name languages
#'
#' @usage data(languages)
#' @format A tibble with 4 rows and 5 variables.
"languages"

#' Language-Specific Scheme Variants
#'
#' A dataset containing the values, schemes, and languages for
#' over three thousand language-specific scheme variants.
#'
#' @docType data
#' @keywords datasets
#' @name schemes
#'
#' @usage data(schemes)
#' @format A tibble with 3583 rows and 3 variables.
"schemes"

#' MIDAS Standardization Examples
#'
#' A dataset containing eight thousand standardization examples
#' of the MIDAS (Marburger Informations-, Dokumentations- und
#' Administrations-System).
#'
#' @docType data
#' @keywords datasets
#' @name midas
#'
#' @usage data(midas)
#' @format A vector of length 8115.
"midas"
