% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oracle.R
\name{oracle_cor}
\alias{oracle_cor}
\title{Calculates the correlation between the true genotype and an
oracle estimator.}
\usage{
oracle_cor(n, ploidy, seq, bias, od, dist)
}
\arguments{
\item{n}{The read-depth.}

\item{ploidy}{The ploidy of the individual.}

\item{seq}{The sequencing error rate.}

\item{bias}{The allele-bias.}

\item{od}{The overdispersion parameter.}

\item{dist}{The distribution of the alleles.}
}
\value{
The Pearson correlation between the true genotype and the oracle estimator.
}
\description{
Calculates the correlation between the oracle MAP estimator (where we have perfect
knowledge about the data generation process) and the true genotype. This is a useful
approximation when you have a lot of individuals.
}
\details{
To come up with \code{dist}, you need some additional assumptions.
For example, if the population is in Hardy-Weinberg equilibrium and
the allele frequency is \code{alpha} then you could calculate
\code{dist} using the R code: \code{dbinom(x = 0:ploidy, size = ploidy, prob = alpha)}.
Alternatively, if you know the genotypes of the individual's two parents are, say,
\code{ref_count1} and \code{ref_count2}, then you could use the \code{\link[updog]{get_q_array}}
function from the updog package: \code{get_q_array(ploidy)[ref_count1 + 1, ref_count2 + 1, ]}.
}
\examples{
## Hardy-Weinberg population with allele-frequency of 0.75.
## Moderate bias and moderate overdispersion.
## See how correlation decreases as we
## increase the ploidy.
ploidy <- 2
dist <- stats::dbinom(0:ploidy, ploidy, 0.75)
oracle_cor(n = 100, ploidy = ploidy, seq = 0.001,
           bias = 0.7, od = 0.01, dist = dist)

ploidy <- 4
dist <- stats::dbinom(0:ploidy, ploidy, 0.75)
oracle_cor(n = 100, ploidy = ploidy, seq = 0.001,
           bias = 0.7, od = 0.01, dist = dist)

ploidy <- 6
dist <- stats::dbinom(0:ploidy, ploidy, 0.75)
oracle_cor(n = 100, ploidy = ploidy, seq = 0.001,
           bias = 0.7, od = 0.01, dist = dist)

}
\references{
Gerard, David, Luis Felipe Ventorim Ferrao,
Antonio Augusto Franco Garcia, and Matthew Stephens. 2018.
"Harnessing Empirical Bayes and Mendelian Segregation
for Genotyping Autopolyploids from Messy Sequencing Data."
\emph{bioRxiv}. Cold Spring Harbor Laboratory. doi:10.1101/281550.
}
\author{
David Gerard
}
