% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ashdog.R
\name{get_q_array}
\alias{get_q_array}
\title{Return the probabilities of an offspring's genotype given its
parental genotypes for all possible combinations of parental and
offspring genotypes. This is for species with polysomal inheritance
and bivalent, non-preferential pairing.}
\usage{
get_q_array(ploidy)
}
\arguments{
\item{ploidy}{A positive integer. The ploidy of the species.}
}
\value{
An three-way array of proportions. The (i, j, k)th element
    is the probability of an offspring having k - 1 reference
    alleles given that parent 1 has i - 1 reference alleles and
    parent 2 has j - 1 reference alleles. Each dimension of the
    array is \code{ploidy + 1}. In the dimension names, "A" stands
    for the reference allele and "a" stands for the
    alternative allele.
}
\description{
Return the probabilities of an offspring's genotype given its
parental genotypes for all possible combinations of parental and
offspring genotypes. This is for species with polysomal inheritance
and bivalent, non-preferential pairing.
}
\examples{
qarray <- get_q_array(6)
apply(qarray, c(1, 2), sum) ## should all be 1's.

}
\author{
David Gerard
}
