% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{grad_for_mu_sigma2}
\alias{grad_for_mu_sigma2}
\title{Gradient for \code{\link{obj_for_mu_sigma2}} with respect for \code{mu} and \code{sigma2}.}
\usage{
grad_for_mu_sigma2(mu, sigma2, phifk_mat, cor_inv, log_bb_dense)
}
\arguments{
\item{mu}{A vector, the ith element is the variational posterior mean of individual i for the SNP.}

\item{sigma2}{A vector, the ith element is the variational posterior variance of individual i for the SNP.}

\item{phifk_mat}{A matrix that contains the standard normal quantile of the beta-binomial cdf at dosage k for individual i.
The rows index the individuals and the columns index the dosages.}

\item{cor_inv}{The inverse of the underlying correlation matrix.}

\item{log_bb_dense}{A matrix of log-densities of the beta binomial. The rows index the individuals and the columns index the allele dosage.
Allele dosage goes from -1 to ploidy, so there are ploidy + 2 elements.}
}
\value{
A vector of length 2 * nind of numerics.
    The first element n elements are the partial derivatives with respect
    to \code{mu} and the second n elements are the
    partial derivatives with respect to \code{sigma2}
    in \code{\link{obj_for_mu_sigma2}}.
}
\description{
Gradient for \code{\link{obj_for_mu_sigma2}} with respect for \code{mu} and \code{sigma2}.
}
\author{
David Gerard
}
\keyword{internal}
