% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_links.R
\name{bitly_create_bitlink}
\alias{bitly_create_bitlink}
\title{Create a short Bitlink}
\usage{
bitly_create_bitlink(long_url = NULL, domain = "bit.ly",
  title = NULL, tags = NULL, group_guid = NULL,
  deeplinks_list = list(app_uri_path = NULL, install_type = NULL,
  install_url = NULL, app_id = NULL), showRequestURL = FALSE)
}
\arguments{
\item{long_url}{- required, a long URL to be shortened (example: http://betaworks.com/). 
Must contain http/https}

\item{domain}{- (optional) the short domain to use; either bit.ly, j.mp, or bitly.com or
a custom short domain. The default for this parameter is the short domain selected by each
user in their bitly account settings. Passing a specific domain via this parameter will override
the default settings.}

\item{title}{- title of the bitlink in \url{https://bit.ly} UI}

\item{tags}{- Array of string, use e.g. \code{c("test1", "test2")}}

\item{group_guid}{- a GUID for a Bitly group}

\item{deeplinks_list}{- a list containing parameters below}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug
purposes.}

\item{app_uri_path}{- app_uri_path}

\item{install_type}{- install_type}

\item{install_url}{- install_url}

\item{app_id}{- app_id}
}
\value{
id - a short bitly identifier for long_url which is unique to the given account.

long_url - This may not always be equal to the URL requested, as some URL normalization 
may occur (e.g., due to encoding differences, or case
differences in the domain). This long_url will always be functionally identical the the request
parameter.

link - an bitly id with http(s) prefix
}
\description{
See \url{https://dev.bitly.com/v4/#section/Rate-Limiting} and
\url{https://dev.bitly.com/v4/#operation/createFullBitlink}
Convert a long url to a Bitlink and set additional parameters.
}
\note{
Look in the vignette for bulk shortening of URLs. Each call of this function == 1 API call.
Take that into consideration due to limits etc.

The bitly API does not support shortening more than one long URL with a single API call.
Meaning 1 Long URL = 1 Function call.

Long URLs should be URL-encoded. You can not include a longUrl in the request
that has &, ?, #, or other reserved parameters without first encoding it.

The default value for the domain parameter is selected by each user from within their bitly
account settings at \url{https://bitly.com/a/settings/advanced}.

Long URLs should not contain spaces: any longUrl with spaces will be rejected. All spaces
should be either percent encoded %20 or plus encoded +. Note that tabs, newlines and trailing
spaces are all indications of errors. Please remember to strip leading and trailing whitespace
from any user input before shortening.
}
\examples{
\dontrun{
bitly_create_bitlink(long_url = "http://slovnik.seznam.cz/")
}

}
