% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{get_stats_for_unique_values}
\alias{get_stats_for_unique_values}
\title{Get stats for unique values}
\usage{
get_stats_for_unique_values(vec1, vec2)
}
\arguments{
\item{vec1}{vector with \code{names} attribute}

\item{vec2}{vector with \code{names} attribute}
}
\value{
A \code{data.frame} consisting of 3 column vectors. The \code{data.frame}
size is \code{nx3}, where n is the number of unique values of \code{vec1} (rows).
The columns vectors are:
  \enumerate{
    \item the first input vector pruned to its unique values
    \item a vector with the average values for each unique value of the
 first vector (the matching is done by column name)
    \item a vector with the standard deviation values for each unique value
    of the first vector (the matching is done by column name)
  }
}
\description{
Use this function on two vectors with same \code{names} attribute (column
names), to find for each unique (numeric) value of the first vector, the
average and standard deviation values of the second vector's values (matching
is done by column name)
}
\examples{
vec1 = c(1, 2, 3, 2)
vec2 = c(20, 2, 2.5, 8)
names.vec = c(seq(1,4))
names(vec1) = names.vec
names(vec2) = names.vec

res = get_stats_for_unique_values(vec1, vec2)

}
