% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{ci}
\alias{use_travis}
\alias{use_appveyor}
\alias{use_gitlab_ci}
\title{Continuous integration setup and badges}
\usage{
use_travis(browse = interactive(), ext = c("org", "com"))

use_appveyor(browse = interactive())

use_gitlab_ci()
}
\arguments{
\item{browse}{Open a browser window to enable automatic builds for the
package.}

\item{ext}{which travis website to use. default to \code{"org"}for
https://travis-ci.org. Change to \code{"com"} for https://travis-ci.com.}
}
\description{
Sets up continuous integration (CI) services for an R package that is
developed on GitHub. CI services can run \code{R CMD check} automatically on
various platforms, triggered by each push or pull request. These functions
\itemize{
\item Add service-specific configuration files and add them to \code{.Rbuildignore}.
\item Activate a service or give the user a detailed prompt.
\item Provide the markdown to insert a badge into README.
}
}
\section{\code{use_travis()}}{

Adds a basic \code{.travis.yml} to the top-level directory of a package. This is a
configuration file for the \href{https://travis-ci.org/}{Travis CI} continuous
integration service.
}

\section{\code{use_appveyor()}}{

Adds a basic \code{appveyor.yml} to the top-level directory of a package. This is
a configuration file for the \href{https://www.appveyor.com}{AppVeyor} continuous
integration service for Windows.
}

\section{\code{use_gitlab_ci()}}{

Adds a basic \code{.gitlab-ci.yml} to the top-level directory of a package. This is
a configuration file for the \href{https://docs.gitlab.com/ee/ci/}{GitLab CI/CD} continuous
integration service for GitLab.
}

