% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github-actions.R, R/tidyverse.R
\name{use_tidy_github_actions}
\alias{use_tidy_github_actions}
\alias{tidyverse}
\alias{create_tidy_package}
\alias{use_tidy_ci}
\alias{use_tidy_description}
\alias{use_tidy_eval}
\alias{use_tidy_contributing}
\alias{use_tidy_support}
\alias{use_tidy_issue_template}
\alias{use_tidy_coc}
\alias{use_tidy_github}
\alias{use_tidy_style}
\alias{use_tidy_release_test_env}
\title{Helpers for tidyverse development}
\usage{
use_tidy_github_actions()

create_tidy_package(path, name = "RStudio")

use_tidy_description()

use_tidy_eval()

use_tidy_contributing()

use_tidy_support()

use_tidy_issue_template()

use_tidy_coc()

use_tidy_github()

use_tidy_style(strict = TRUE)

use_tidy_release_test_env()
}
\arguments{
\item{path}{A path. If it exists, it is used. If it does not exist, it is
created, provided that the parent path exists.}

\item{name}{Name of the copyright holder or holders. Separate multiple
individuals with \verb{;}. You can supply a global default with
\code{options(usethis.full_name = "My name")}.}

\item{strict}{Boolean indicating whether or not a strict version of styling
should be applied. See \code{\link[styler:tidyverse_style]{styler::tidyverse_style()}} for details.}
}
\description{
These helpers follow tidyverse conventions which are generally a little
stricter than the defaults, reflecting the need for greater rigor in
commonly used packages.
}
\details{
\itemize{
\item \code{use_tidy_github_actions()}: Sets up the following workflows using \href{https://github.com/features/actions}{GitHub Actions}:
\itemize{
\item Runs \verb{R CMD check} on the current release, devel, and four previous
versions of R.
\item Adds adds two commands to be used in pull requests: \verb{/document} to run
\code{roxygen2::roxygenise()} and update the PR, and \verb{/style} to run
\code{styler::style_pkg()} and update the PR.
\item Builds a pkgdown site for the package.
}
}

\itemize{
\item \code{create_tidy_package()}: creates a new package, immediately applies as many
of the tidyverse conventions as possible, issues a few reminders, and
activates the new package.
\item \code{use_tidy_description()}: puts fields in standard order and alphabetises
dependencies.
\item \code{use_tidy_eval()}: imports a standard set of helpers to facilitate
programming with the tidy eval toolkit.
\item \code{use_tidy_style()}: styles source code according to the \href{https://style.tidyverse.org}{tidyverse style guide}. This function will overwrite files! See
below for usage advice.
\item \code{use_tidy_contributing()}: adds standard tidyverse contributing guidelines.
\item \code{use_tidy_issue_template()}: adds a standard tidyverse issue template.
\item \code{use_tidy_release_test_env()}: updates the test environment section in
\code{cran-comments.md}.
\item \code{use_tidy_support()}: adds a standard description of support resources for
the tidyverse.
\item \code{use_tidy_coc()}: equivalent to \code{use_code_of_conduct()}, but puts the
document in a \verb{.github/} subdirectory.
\item \code{use_tidy_github()}: convenience wrapper that calls
\code{use_tidy_contributing()}, \code{use_tidy_issue_template()}, \code{use_tidy_support()},
\code{use_tidy_coc()}.
}
}
\section{\code{use_tidy_style()}}{

Uses the \href{https://styler.r-lib.org}{styler package} package to style all code
in a package, project, or directory, according to the \href{https://style.tidyverse.org}{tidyverse style guide}.

\strong{Warning:} This function will overwrite files! It is strongly suggested to
only style files that are under version control or to first create a backup
copy.

Invisibly returns a data frame with one row per file, that indicates whether
styling caused a change.
}

