% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate.R
\name{tabulate_model.glm}
\alias{tabulate_model.glm}
\title{Tabulate Model: GLM}
\usage{
\method{tabulate_model}{glm}(fit, format = TRUE, percent.sign = TRUE,
  digits = 1, p.digits = 4)
}
\arguments{
\item{fit}{Required. MASS::glm(family = 'binomial') object.}

\item{format}{Optional. Logical. Rounds numbers and formats text for a
cleaner, readable output. Defaults to TRUE.}

\item{percent.sign}{Optional. Logical. Indicates percent sign should be printed
for frequencies. Defaults to TRUE.}

\item{digits}{Optional. Integer. Number of digits to round to. Defaults to 1.}

\item{p.digits}{Optional. Integer. Number of p-value digits to print. Note that
p-values are still rounded using 'digits'. Defaults to 4.}
}
\description{
Converts parameters from a generalized linear model into a usable
table for publication purposes.
}
\examples{
library(dplyr)
library(MASS)

# glm() Object
logit_data <- MASS::birthwt \%>\%
  mutate_at(c('race'), as.factor) \%>\%
  mutate_at(c('low', 'smoke', 'ht', 'ui'), as.logical)
tabulate_model(
  fit = stats::glm(
    low ~ race + smoke + age,
    data = logit_data,
    family = 'binomial'
   )
)
}
\seealso{
\code{\link{tabulate_model}}
}
