% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg.R
\name{ggrisktable}
\alias{ggrisktable}
\title{Create a ggplot2 table showing the number at risk}
\usage{
ggrisktable(fit, times)
}
\arguments{
\item{fit}{Required. survival::survfit() object.}

\item{times}{Required. Numeric. One or more time points to calculate
the number at risk for.}
}
\value{
An unformatted ggplot2 table showing the number at risk.
}
\description{
A simple wrapper function which calculates the
numbers at risk for a survival model and a given set of time points then
creates a ggplot2 table with them.
}
\examples{
library(survival)

fit <- survfit(Surv(time, status) ~ trt, data = diabetic)

ggrisktable(fit, c(0, 10, 20, 30, 40, 50)) +
  theme_risk_black()
}
