% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_br.R
\name{br}
\alias{br}
\title{Binary Relevance for multi-label Classification}
\usage{
br(
  mdata,
  base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  ...,
  cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA)
)
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{...}{Others arguments passed to the base algorithm for all subproblems}

\item{cores}{The number of cores to parallelize the training. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{BRmodel} containing the set of fitted
  models, including:
  \describe{
   \item{labels}{A vector with the label names.}
   \item{models}{A list of the generated models, named by the label names.}
  }
}
\description{
Create a Binary Relevance model for multilabel classification.
}
\details{
Binary Relevance is a simple and effective transformation method to predict
multi-label data. This is based on the one-versus-all approach to build a
specific model for each label.
}
\examples{
model <- br(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
# Use SVM as base algorithm
model <- br(toyml, "SVM")
pred <- predict(model, toyml)

# Change the base algorithm and use 4 CORES
model <- br(toyml[1:50], 'RF', cores = 4, seed = 123)

# Set a parameters for all subproblems
model <- br(toyml, 'KNN', k=5)
}
}
\references{
Boutell, M. R., Luo, J., Shen, X., & Brown, C. M. (2004). Learning
   multi-label scene classification. Pattern Recognition, 37(9), 1757-1771.
}
\seealso{
Other Transformation methods: 
\code{\link{brplus}()},
\code{\link{cc}()},
\code{\link{clr}()},
\code{\link{ctrl}()},
\code{\link{dbr}()},
\code{\link{ebr}()},
\code{\link{ecc}()},
\code{\link{eps}()},
\code{\link{esl}()},
\code{\link{homer}()},
\code{\link{lift}()},
\code{\link{lp}()},
\code{\link{mbr}()},
\code{\link{ns}()},
\code{\link{ppt}()},
\code{\link{prudent}()},
\code{\link{ps}()},
\code{\link{rakel}()},
\code{\link{rdbr}()},
\code{\link{rpc}()}
}
\concept{Transformation methods}
