% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_prudent.R
\name{prudent}
\alias{prudent}
\title{PruDent classifier for multi-label Classification}
\usage{
prudent(
  mdata,
  base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  phi = 0,
  ...,
  cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA)
)
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{phi}{A value between 0 and 1 to determine the information gain. The
value 0 include all labels in the second phase and the 1 none.}

\item{...}{Others arguments passed to the base algorithm for all subproblems.}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{PruDentmodel} containing the set of fitted
  models, including:
  \describe{
   \item{labels}{A vector with the label names.}
   \item{phi}{The value of \code{phi} parameter.}
   \item{IG}{The matrix of Information Gain used in combination
     with \code{phi} parameter to define the labels used in the second step.
   }
   \item{basemodel}{The BRModel used in the first iteration.}
   \item{metamodels}{A list of models named by the label names used in the
     second iteration.
   }
}
}
\description{
Create a PruDent classifier to predict multi-label data. To this, two
round of Binary Relevance is executed, such that, the first iteration
generates new attributes to enrich the second prediction.
}
\details{
In the second phase only labels whose information gain is greater than a
specific phi value is added.
}
\examples{
model <- prudent(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
# Use different phi correlation with J48 classifier
model <- prudent(toyml, 'J48', 0.3)

# Set a specific parameter
model <- prudent(toyml, 'KNN', k=5)
}
}
\references{
Alali, A., & Kubat, M. (2015). PruDent: A Pruned and Confident Stacking
   Approach for Multi-Label Classification. IEEE Transactions on Knowledge
   and Data Engineering, 27(9), 2480-2493.
}
\seealso{
Other Transformation methods: 
\code{\link{brplus}()},
\code{\link{br}()},
\code{\link{cc}()},
\code{\link{clr}()},
\code{\link{ctrl}()},
\code{\link{dbr}()},
\code{\link{ebr}()},
\code{\link{ecc}()},
\code{\link{eps}()},
\code{\link{esl}()},
\code{\link{homer}()},
\code{\link{lift}()},
\code{\link{lp}()},
\code{\link{mbr}()},
\code{\link{ns}()},
\code{\link{ppt}()},
\code{\link{ps}()},
\code{\link{rakel}()},
\code{\link{rdbr}()},
\code{\link{rpc}()}
}
\concept{Transformation methods}
