% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utr_analysis.R
\name{countDNAPatternInAlt}
\alias{countDNAPatternInAlt}
\title{Count the number of DNA pattern in the altered sequence of each transcript.}
\usage{
countDNAPatternInAlt(
  variantsTable,
  seqTable,
  transcriptsTable,
  dnaPattern,
  transcriptIdCol
)
}
\arguments{
\item{variantsTable}{variants table}

\item{seqTable}{sequences table containing columns: ensembl_transcript_id and seq. seq is the sequence of a seqType region: e.g. 5' UTR sequence or 3' UTR sequence.
The seqTable is output from function getSeqTable.}

\item{dnaPattern}{the string pattern that you want to count, for example "ATG"}

\item{transcriptIdCol}{the ensemble transcript id column}

\item{trascriptsTable}{transcripts structure table from ensembl with start and end columns for start and end coordinates of the target regions}
}
\value{
a list containing values for number of DNA pattern. Can be used to add new column to the variants table.
}
\description{
\code{countDNAPatternInAlt} Count the number of DNA pattern in the altered sequence of each transcript, and concatenate the numbers with ";". The alter sequence is generated by find the fragment where Pos is in, replace the Ref with Alt in the fragments, and then concatenating all fragments together.
}
\keyword{internal}
