% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.validann.R
\name{plot.validann}
\alias{plot.validann}
\title{Plot ANN validation results.}
\usage{
\method{plot}{validann}(x, obs, sim, gof = TRUE, resid = TRUE, sa = TRUE,
  display = c("multi", "single"), profile = c("all", "median"), ...)
}
\arguments{
\item{x}{object of class `validann' as returned
by \code{\link{validann}}. This is a list comprising metrics and
statistics that can be used for validating ANN models.}

\item{obs,sim}{vectors comprising observed (\code{obs}) and simulated
(\code{sim}) examples of a single response variable used for computing
\code{x} object.}

\item{gof}{logical; should goodness-of-fit plots be produced?
Default = TRUE.}

\item{resid}{logical; should residual analysis plots be produced?
Default = TRUE.}

\item{sa}{logical; should input sensitivity analysis plots be
produced? Default = TRUE.}

\item{display}{character string defining how plots should be
displayed. The default is ``multi'' where multiple plots are displayed
together according to whether they are goodness-of-fit, residual analysis
or sensitivity analysis plots. For ``single'', each plot is displayed on
its own. If the session is interactive, the user will be asked to confirm
a new page whether \code{display} is ``single'' or ``multi''.}

\item{profile}{character string defining which structural
validity Profile method outputs should be plotted. The default is ``all''
where outputs corresponding to 5 summary statistics are plotted together
with the median predicted response for each input value.
For ``median'', only the median response is plotted.}

\item{\dots}{Arguments to be passed to plot (not currently used).}
}
\description{
Plot method for objects of class `validann'. Produces a series
   of plots used for validating and assessing ANN models based on results
   returned by \code{\link{validann}}.
}
\details{
This function can be invoked by calling
   \code{plot(x, obs, sim)} for an object \code{x} of class
   `validann'.

   To produce plots for all types of validation metrics and statistics,
   \code{gof}, \code{resid} and \code{sa} must be
   \code{TRUE} and corresponding results must have been successfully
   computed by \code{\link{validann}} and returned in object \code{x}.

   If \code{gof} is \code{TRUE}, a scatter plot, Q-Q plot and
   time/sample plot of observed (\code{obs}) versus predicted (\code{sim})
   data are produced.

   If \code{resid} is \code{TRUE} and \code{x$residuals}
   is not \code{NULL}, plots of the model residuals are produced including
   histogram, Q-Q plot (standardized residuals compared to standard normal),
   autocorrelation (acf), partial autocorrelation (pacf), standardized
   residual versus predicted output (i.e. \code{sim}) and standardized
   residual versus time/order of the data.

   If \code{sa} is \code{TRUE} and \code{x$y_hat} is not
   \code{NULL}, model response values resulting from the Profile
   sensitivity analysis are plotted against percentiles of each
   input. If \code{x$rs} is not \code{NULL}, the relative sensitivities of
   each input, as computed by the partial derivative (PaD) sensitivity
   analysis, are plotted against predicted output.

   Setting \code{gof}, \code{resid} and/or \code{sa} to \code{FALSE}
   will `turn off' the respective validation plots.
}
\examples{
## Build ANN model and compute replicative and structural validation results
data("ar9")
samp <- sample(1:1000, 200)
y <- ar9[samp, ncol(ar9)]
x <- ar9[samp, -ncol(ar9)]
x <- x[, c(1,4,9)]
fit <- ann(x, y, size = 1, act_hid = "tanh", act_out = "linear", rang = 0.1)
results <- validann(fit, x = x)
obs <- observed(fit)
sim <- fitted(fit)

## Plot replicative and structural validation results to the current device
## - a single page for each type of validation
plot(results, obs, sim)

## Plot results to the current device - a single page for each plot
plot(results, obs, sim, display = "single")

## Plot replicative and structural validation results to single file
pdf("RepStructValidationPlots.pdf")
plot(results, obs, sim)
dev.off()

## Get predictive validation results for above model based on a new sample
## of ar9 data.
samp <- sample(1:1000, 200)
y <- ar9[samp, ncol(ar9)]
x <- ar9[samp, -ncol(ar9)]
x <- x[, c(1,4,9)]
obs <- y
sim <- predict(fit, newdata = x)
results <- validann(fit, obs = obs, sim = sim, x = x)

## Plot predictive results only to file
pdf("PredValidationPlots.pdf")
plot(results, obs, sim, resid = FALSE, sa = FALSE)
dev.off()
}
\seealso{
\code{\link{validann}}
}

