% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/expressionset.R, R/parse.R
\docType{methods}
\name{validate_options,expressionset-method}
\alias{validate_options}
\alias{validate_options,ANY-method}
\alias{validate_options,expressionset-method}
\alias{validate_reset}
\alias{validate_reset,ANY-method}
\alias{validate_reset,expressionset-method}
\title{Set or get options globally or per object.}
\usage{
\S4method{validate_options}{expressionset}(x = NULL, ...)

\S4method{validate_reset}{expressionset}(x = NULL)

validate_options(x = NULL, ...)

\S4method{validate_options}{ANY}(x = NULL, ...)

validate_reset(x = NULL)

\S4method{validate_reset}{ANY}(x = NULL)
}
\arguments{
\item{x}{(optional) an object inheriting from \code{expressionset} such as \code{\link{validator}} or \code{\link{indicator}}.}

\item{...}{Name of an option (character) to retrieve options or \code{option = value} pairs to set options.}
}
\value{
When requesting option settings: a \code{list}. When setting options, the whole options
list is returned silently.
}
\description{
Set or get options globally or per object.
}
\section{Options for the validate package}{

Currently the following options are supported.

\itemize{
 \item{raise ('none','error','all'; 'none') Control if the \code{\link{confront}} methods catch or raise exceptions.
 The 'all' setting is useful when debugging validation scripts.}
 \item{lin.eq.eps ('numeric'; 1e-8) The precision used when evaluating linear equalities.
    To be used to control for machine rounding.}
 \item{'reset'} Reset to factory settings.
}
}

\section{Details}{

There are three ways in which options can be specified.
\itemize{
\item{Globally. Setting \code{validate_options(option1=value1,option2=value2,...)} sets global options.
\item{Per object. Setting \code{validate_options(where=<object>, option1=value1,...)}, causes all relevant functions
that use that object (e.g. \code{\link{confront}}) to use those local settings.}
\item{At execution time. Relevant functions (e.g. \code{\link{confront}}) take optional arguments allowing one
to define options to be used during the current function call}
}}

To set options in a file, use \code{validate_options(option1=value1,option2=value2,...)} without the \code{where}
argument. This will invoke a local setting in the object created when the file is parsed.
}
\examples{
# the default allowed validation symbols.
validate_options('validator_symbols')

# set an option, local to a validator object:
v <- validator(x + y > z)
validate_options(v,raise='all')
# check that local option was set:
validate_options(v,'raise')
# check that global options have not changed:
validate_options('raise')
}

