% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_pkg.R
\docType{package}
\name{validate}
\alias{validate}
\alias{validate-package}
\alias{package-validate}
\title{Data Validation Infrastructure}
\description{
Data often suffer from errors and missing values. A necessary step before data
analysis is verifying and validating your data. Package \code{validate} is a
toolbox for creating validation rules and checking data against these rules.
}
\section{Getting started}{


The easiest way to get started is through the examples given in \code{\link{check_that}}. 

The general workflow in \code{validate} follows the following pattern.
\itemize{
  \item Define a set of rules or quality indicator using \code{\link{validator}} or \code{\link{indicator}}. 
  \item \code{\link{confront}} data with the rules or indicators,
  \item Examine the results either graphically or by summary.
}

There are several convenience functions that allow one to define rules from
the commandline, through a (freeform or yaml) file and to investigate and
maintain the rules themselves. Please have a look at the
\href{../doc/cookbook.html}{cookbook} for a comprehensive introduction.
}

\references{
An overview of this package, its underlying ideas and many examples
can be found in MPJ van der Loo and E. de Jonge (2018) \emph{Statistical
data cleaning with applications in R} John Wiley & Sons.

Please use \code{citation("validate")} to get a citation for (scientific)
publications.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/data-cleaning/validate}
  \item Report bugs at \url{https://github.com/data-cleaning/validate/issues}
}

}
\author{
\strong{Maintainer}: Mark van der Loo \email{mark.vanderloo@gmail.com} (\href{https://orcid.org/0000-0002-9807-4686}{ORCID})

Authors:
\itemize{
  \item Edwin de Jonge (\href{https://orcid.org/0000-0002-6580-4718}{ORCID})
}

Other contributors:
\itemize{
  \item Paul Hsieh [contributor]
}

}
