% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_closest.r
\name{bed_closest}
\alias{bed_closest}
\title{Identify closest intervals.}
\usage{
bed_closest(x, y, overlap = TRUE, suffix = c(".x", ".y"))
}
\arguments{
\item{x}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{y}{\code{\link[=tbl_interval]{tbl_interval()}}}

\item{overlap}{report overlapping intervals}

\item{suffix}{colname suffixes in output}
}
\value{
\code{\link[=tbl_interval]{tbl_interval()}} with additional columns:
\itemize{
\item \code{.dist} distance to closest interval, negative distances denote upstream intervals
\item \code{.overlap} overlap with closest interval
}
}
\description{
Identify closest intervals.
}
\details{
input tbls are grouped by \code{chrom} by default, and additional
groups can be added using \code{\link[dplyr:group_by]{dplyr::group_by()}}. For example,
grouping by \code{strand} will constrain analyses to the same strand. To
compare opposing strands across two tbls, strands on the \code{y} tbl can
first be inverted using \code{\link[=flip_strands]{flip_strands()}}.
}
\examples{
x <- trbl_interval(
  ~chrom, ~start, ~end,
  'chr1',      100,     125
)

y <- trbl_interval(
  ~chrom, ~start, ~end,
  'chr1',      25,      50,
  'chr1',     140,     175
)

bed_glyph(bed_closest(x, y))

x <- trbl_interval(
  ~chrom, ~start, ~end,
  "chr1", 500,    600,
  "chr2", 5000,   6000
)

y <- trbl_interval(
~chrom, ~start, ~end,
  "chr1", 100,    200,
  "chr1", 150,    200,
  "chr1", 550,    580,
  "chr2", 7000,   8500
)

bed_closest(x, y)

bed_closest(x, y, overlap = FALSE)

# Report distance based on strand
x <- trbl_interval(
  ~chrom, ~start, ~end, ~name, ~score, ~strand,
  "chr1", 10,	   20,   "a",   1,      "-"
)

y <- trbl_interval(
  ~chrom, ~start, ~end, ~name, ~score, ~strand,
  "chr1", 8,	     9,	   "b",   1,      "+",
  "chr1", 21,	   22,	 "b",   1,      "-"
)

res <- bed_closest(x, y)

# convert distance based on strand
res$.dist_strand <- ifelse(res$strand.x == "+", res$.dist, -(res$.dist))
res

# report absolute distances
res$.abs_dist <- abs(res$.dist)
res

}
\seealso{
\url{http://bedtools.readthedocs.io/en/latest/content/tools/closest.html}

Other multiple set operations: \code{\link{bed_coverage}},
  \code{\link{bed_intersect}}, \code{\link{bed_map}},
  \code{\link{bed_subtract}}, \code{\link{bed_window}}
}
