% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_fisher.r
\name{bed_fisher}
\alias{bed_fisher}
\title{Fisher's test to measure overlap between two sets of intervals.}
\usage{
bed_fisher(x, y, genome)
}
\arguments{
\item{x}{\link{ivl_df}}

\item{y}{\link{ivl_df}}

\item{genome}{\link{genome_df}}
}
\value{
\link{ivl_df}
}
\description{
Calculate Fisher's test on number of intervals that are shared and unique
between two sets of \code{x} and \code{y} intervals.
}
\details{
Interval statistics can be used in combination with
\code{\link[dplyr:group_by]{dplyr::group_by()}} and \code{\link[dplyr:do]{dplyr::do()}} to calculate
statistics for subsets of data. See \code{vignette('interval-stats')} for
examples.
}
\examples{
genome <- read_genome(valr_example('hg19.chrom.sizes.gz'))

x <- bed_random(genome, n = 1e4, seed = 1010486)
y <- bed_random(genome, n = 1e4, seed = 9203911)

bed_fisher(x, y, genome)

}
\seealso{
\url{https://bedtools.readthedocs.io/en/latest/content/tools/fisher.html}

Other interval statistics: 
\code{\link{bed_absdist}()},
\code{\link{bed_jaccard}()},
\code{\link{bed_projection}()},
\code{\link{bed_reldist}()}
}
\concept{interval statistics}
