% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openxlsxCommands.R
\name{oxWaterOccurrenceSheet}
\alias{oxWaterOccurrenceSheet}
\title{openxlsx Water Occurrence Summary}
\usage{
oxWaterOccurrenceSheet(wb.name, sheet.name = "WaterOccurrenceSummary", df)
}
\arguments{
\item{wb.name}{Name of the workbook for the results; \emph{e.g.}, results.wb}

\item{sheet.name}{Name of the worksheet being formatted; default:
\code{"WaterOccurrenceSummary"}}

\item{df}{data.frame containing the water occurrence results of the
\code{\link[=ConservedWaters]{ConservedWaters()}} function; \emph{e.g.}, \code{h2o.occurrence}}
}
\value{
The workbook containing the indicated and newly formatted worksheet.
}
\description{
Constructs the \link{openxlsx} worksheet for the Water Occurrence
summary.
}
\details{
\strong{This function is to \emph{ONLY} be used with the results of
\code{\link[=ConservedWaters]{ConservedWaters()}}}. Specific aspects of how the
returned \code{data.frame} will be formatted are \strong{hard-coded} into this
function.

This \link{openxlsx} function is \emph{\strong{NOT}} exported.
}
\seealso{
Other "openxlsx functions": \code{\link{openxlsxCellStyles}},
  \code{\link{oxAlignOverlapSheet}},
  \code{\link{oxClusterStatsSheet}},
  \code{\link{oxClusterSummarySheet}},
  \code{\link{oxInitWaterDataSheet}},
  \code{\link{oxPDBcleanedSummarySheet}},
  \code{\link{oxPlainDataSheet}},
  \code{\link{oxRCSBinfoSheet}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
