% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hst.R
\name{hst}
\alias{hst}
\title{Simplified Histogram}
\usage{
hst(df, var1, by1, by2)
}
\arguments{
\item{df}{data frame to read in.}

\item{var1}{the dependent/outcome variable, \eqn{Y}. The variable of interest that should be plotted.}

\item{by1}{the main independent/predictor variable, \eqn{X_1}. A grouping variable by which the histogram for \code{var1} should be parsed.}

\item{by2}{a potential second independent/predictor variable, \eqn{X_2}. A second grouping variable by which the histogram for \code{var1} (already parsed by \code{by1}) should be parsed.}
}
\value{
This function returns the histogram for \code{var1} in data frame \code{df}. Can be split to return a histogram for \code{var1} in data frame \code{df}, broken out by \code{var2}.
}
\description{
This function plots a histogram (hst) on a given data frame, and uses simplified calls within the function to parse the histogram by up to 2 variables.
}
\examples{
data <- mtcars

hst(data,mpg,cyl)
}
