% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/modeler.R
\name{vm_stan}
\alias{vm_stan}
\title{Create a Stan class VM object}
\usage{
vm_stan(design = c("V -> Y", "V -> M -> Y", "V", "X -> V", "X -> V -> Y",
  "X -> M -> V"), useU = TRUE, ...)
}
\arguments{
\item{design}{A character string indicating the type of model to be run.  One of
\dQuote{V -> Y} for variability predicting an outcome,
\dQuote{V -> M -> Y} for mediation of variability on an outcome,
\dQuote{V} to take posterior samples of individual variability estimates alone.}

\item{useU}{A logical value whether the latent intercept estimated in Stage 1 should
also be used as a predictor.  Defaults to \code{TRUE}.}

\item{\dots}{Additional arguments passed to \code{stan_model}.}
}
\value{
A compiled Stan model.
}
\description{
Internal function to create and compile a Stan model.
}
\examples{
# Make Me!
\dontrun{
  test1 <- vm_stan("V -> Y", useU=TRUE)
  test2 <- vm_stan("V -> Y", useU=FALSE)
  test3 <- vm_stan("V -> M -> Y", useU=TRUE)
  test4 <- vm_stan("V -> M -> Y", useU=FALSE)
  test5 <- vm_stan("V")
}
}
\author{
Joshua F. Wiley <josh@elkhartgroup.com>
}
\keyword{models}

