library(variosig)
library(gstat)
library(sp)
library(geoR)
library(testthat)

data(meuse)
coordinates(meuse) = ~x+y
vario0 <- variogram(zinc~1, data = meuse)
perm <- envelope(vario0, data = meuse, formula = zinc~1, nsim = 9, cutoff = 1500)
expect_that(perm, is_a("list"))
expect_that(envsig(perm), is_a("list"))
expect_that(envplot(perm), is_a("character"))

vario1 <- variogram(log(zinc)~1, data = meuse)
perm <- envelope(vario1, data = meuse, formula = log(zinc)~1, nsim = 9)
expect_that(perm, is_a("list"))
expect_that(envsig(perm), is_a("list"))
expect_that(envplot(perm), is_a("character"))

data(meuse)
meuse <- as.geodata(meuse, coords.col = 1:2, data.col = 6, covar.col = 3:5)
meuse$data <- log(meuse$data)
vario2 <- variog(meuse,max.dist=1500)
perm2 <- envelope(vario2, meuse, nsim=9, max.dist=1500)
expect_that(perm2, is_a("list"))
expect_that(envsig(perm2), is_a("list"))
expect_that(envplot(perm2), is_a("character"))

vario3 <- variog(meuse,trend = trend.spatial(~lead, meuse),max.dist=1500)
perm3 <- envelope(vario3, meuse, trend = trend.spatial(~lead, meuse),nsim=9, max.dist=1500)
expect_that(perm3, is_a("list"))
expect_that(envsig(perm3), is_a("list"))
expect_that(envplot(perm3), is_a("character"))
