\name{restrict}

\alias{restrict}

\title{Restricted VAR}

\encoding{latin1}

\description{
  Estimation of a VAR, by imposing zero restrictions manually or by
  significance.
}

\usage{
restrict(x, method = c("ser", "manual"), thresh = 2.0, resmat = NULL)
}

\arguments{
  \item{x}{An object of class \sQuote{\code{varest}} generated by
    \command{VAR()}.}  
  \item{method}{A character, choosing the method}
  \item{thresh}{If method \code{ser}: the threshhold value for the
    t-statistics.}
  \item{resmat}{If method \code{manual}: The restriction matrix.} 
}

\details{
Given an estimated VAR object of class \sQuote{\code{varest}}, a restricted VAR
can be obtained by either choosing method \code{ser} or
\code{manual}. In the former case, each equation is re-estimated
separately as long as there are t-values that are in absolut value below the
threshhold value set by the function's argument \code{thresh}. In the
latter case, a restriction matrix has to be provided that consists of
0/1 values, thereby selecting the coefficients to be retained in the
model.}

\value{
  A list with class attribute \sQuote{\code{varest}} holding the
  following elements:\cr

  \item{varresult}{list of \sQuote{\code{lm}} objects.}
  \item{resid}{A matrix object of the residuals.}
  \item{datamat}{The data matrix of the endogenous and explanatory variables.}
  \item{y}{The data matrix of the endogenous variables}
  \item{type}{A character, specifying the deterministic regressors.}
  \item{p}{An integer specifying the lag order.}
  \item{K}{An integer specifying the dimension of the VAR.}
  \item{obs}{An integer specifying the number of used observations.}
  \item{totobs}{An integer specifying the total number of observations.}
  \item{restrictions}{The matrix object containing the zero restrictions
    provided as argument \code{resmat}.}
  \item{call}{The \code{call} to \command{VAR()}.}
}

\note{
  Currently, the restricted VAR is estimated by OLS and not by an
  efficient EGLS-method.
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.  
}

\seealso{
  \code{\link{VAR}}
}

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
## Restrictions by significance
restrict(var.2c, method = "ser")
## Restrictions set manually
restrict <- matrix(c(1, 1, 1, 1, 1, 1, 0, 0, 0, 
                     1, 0, 1, 0, 0, 1, 0, 1, 1,
                     0, 0, 1, 1, 0, 1, 0, 0, 1,
                     1, 1, 1, 0, 1, 1, 0, 1, 0),
                   nrow=4, ncol=9, byrow=TRUE)
restrict(var.2c, method = "man", resmat = restrict)
}

\keyword{regression}
\concept{VAR}
\concept{restricted VAR}
\concept{Vector autoregressive model}
