\name{predict}

\alias{predict}

\alias{predict.varest}

\alias{predict.vec2var}

\alias{print.varprd}

\encoding{latin1}

\title{Predict method for objects of class varest and vec2var}

\description{
  Forecating a VAR object of class \sQuote{\code{varest}} or of class
  \sQuote{\code{vec2var}} with confidence bands.
}

\usage{
\method{predict}{varest}(object, ..., n.ahead = 10, ci = 0.95, dumvar = NULL)
\method{predict}{vec2var}(object, ..., n.ahead = 10, ci = 0.95, dumvar = NULL)
}
\arguments{
  \item{object}{An object of class \sQuote{\code{varest}}; generated by
    \command{VAR()}, or an object of class \sQuote{\code{vec2var}};
    generated by \command{vec2var()}.} 
  \item{n.ahead}{An integer specifying the number of forecast steps.}
  \item{ci}{The forecast confidence interval}
  \item{dumvar}{Matrix for objects of class \sQuote{\code{vec2var}} or
    \sQuote{\code{varest}}, if the \code{dumvar} argument in
    \command{ca.jo()} has been used or if the \code{exogen} argument in
    \command{VAR()} has been used, respectively. The matrix should have
    the same column dimension as in the call to \command{ca.jo()} or to
    \command{VAR()} and row dimension equal to \code{n.ahead}.}
  \item{\dots}{Currently not used.}
}
\details{
  The \code{n.ahead} forecasts are computed recursively for the
  estimated VAR, beginning with \eqn{h = 1, 2, \ldots, n.ahead}:  

  \deqn{
    \bold{y}_{T+1 | T} = A_1 \bold{y}_T  + \ldots + A_p \bold{y}_{T+1-p} +
    C D_{T+1}
  }
  
  The variance-covariance matrix of the forecast errors is a function of
  \eqn{\Sigma_u} and \eqn{\Phi_s}. 
}

\value{
  A list with class attribute \sQuote{\code{varprd}} holding the
  following elements:\cr
  
  \item{fcst}{A list of matrices per endogenous variable containing the
    forecasted values with lower and upper bounds as well as the
    confidence interval.} 
  \item{endog}{Matrix of the in-sample endogenous variables.}
  \item{model}{The estimated VAR \code{object}.}
  \item{exo.fcst}{If applicable provided values of exogenous variables,
    otherwise \code{NULL}.}
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.  
}

\seealso{
  \code{\link{VAR}}, \code{\link{vec2var}}, \code{\link{plot.varprd}},
  \code{\link{fanchart}}
} 

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
predict(var.2c, n.ahead = 8, ci = 0.95) 
}

\keyword{regression}
\concept{VAR}
\concept{VECM}
\concept{Vector autoregressive}
\concept{Forecasts of VAR}
\concept{Prediction of VAR}
