% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_misc.R
\name{cor.from.t}
\alias{cor.from.t}
\title{Compute Pearson correlation between paired measurements from t statistic}
\usage{
cor.from.t(m1, m2, sd1, sd2, t, n)
}
\arguments{
\item{m1}{sample mean for measurement 1}

\item{m2}{sample mean for measurement 2}

\item{sd1}{sample standard deviation for measurement 1}

\item{sd2}{sample standard deviation for measurement 2}

\item{t}{value for paired-samples t-test}

\item{n}{sample size}
}
\value{
Returns the sample Pearson correlation between the two paired measurements
}
\description{
This function computes the Pearson correlation between paired
measurements using a reported paired-samples t statistic and
other sample information. This correlation estimate is needed
in several functions that analyze mean differences and
standardized mean differences in paired-samples studies.
}
\examples{
cor.from.t(9.4, 9.8, 1.26, 1.40, 2.27, 30)

# Should return:
# [1] 0.7415209

}
